#pragma once

struct stack_node;
struct stack {
	struct stack_node* head;
};

struct stack new_stack();
void copy_stack(struct stack* dst, const struct stack* src, void* (*copy)(const void*));
struct stack* assign_stack(struct stack* dst, const struct stack* src, 
	void* (*copy_el)(const void*), void (*free_el)(void*));
void clear_stack(struct stack* s, void (*free_el)(void*));

_Bool stack_empty(const struct stack* s);
void push_stack(struct stack* s, void* value);
void* pop_stack(struct stack* s);
