#include <stdio.h>
#include <ctype.h>

int most_frequent(const char * str, char * ret_ch) {
  char freqs [26] = { 0 };
  int ret_freq = 0;
  for (int i = 0; str[i] != '\0'; ++i) {
    if (isalpha(str[i])) {        // only count letters
      int ch = tolower(str[i]);   // convert to lower case
      int idx = ch-'a';
      if (++freqs[idx] > ret_freq) {  // update on new max
        ret_freq = freqs[idx];
        *ret_ch = ch;
      }
    }
  }
  return ret_freq;
}

void dothing(const char * str) {
  char ch;
  int freq = most_frequent(str, &ch);
  printf("%s -- %d %c\n", str, freq, ch);
}

int main() {
  dothing("hello");
  dothing("hello, world!");
  dothing("aaabbbba");
  dothing("");
}
