#include <cstdio>

#include "bench.h"

volatile int go = 0;

_Monitor M {
public:
	void __attribute__((noinline)) call() {}

	int __attribute__((noinline)) wait() {
		go = 1;
		for ( size_t i = 0; i < times; i++ ) {
			_Accept(call);
		}
		go = 0;
		return 0;
	}
} m;

_Task T {
	void main() {
		while ( go == 0 ) { yield(); }
		BENCH(
			while ( go == 1 ) { m.call(); },
			result
		)
		printf( "%g\n", result );
	}
};

int main( int argc, char * argv[] ) {
	BENCH_START()
	T t;
	return m.wait();
}

// Local Variables: //
// tab-width: 4 //
// End: //
