//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ParseNode.cc -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Sat May 16 13:26:29 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Aug 16 21:31:47 2016
// Update Count     : 125
// 

#include "ParseNode.h"
using namespace std;

int ParseNode::indent_by = 4;

ParseNode::ParseNode() {};
ParseNode::ParseNode( const string *name ) : name( *name ) { assert( false ); delete name; }
ParseNode::ParseNode( const string &name ) : name( name ) { assert( false ); }

ParseNode::~ParseNode() {
	delete next;
};

ParseNode *ParseNode::get_last() {
	ParseNode *current;
	for ( current = this; current->get_next() != 0; current = current->get_next() );
	return current;
}

ParseNode *ParseNode::set_last( ParseNode *newlast ) {
	if ( newlast != 0 ) get_last()->set_next( newlast );
	return this;
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
