#include <stdio.h>
#include <stdlib.h>
#include "bench.h"
#include "c-pair.h"
#include "c-stack.h"

char * new_char( char c ) {
	char* q = malloc( sizeof(char) ); /***/
	*q = c;
	return q;
}

short * new_short( short s ) {
	short* q = malloc( sizeof(short) ); /***/
	*q = s;
	return q;
}

int* new_int( int i ) {
	int* q = malloc( sizeof(int) ); /***/
	*q = i;
	return q;
}

void * copy_char( const void * p ) { return new_char( *(const char*)p ); } /***/
void * copy_short( const void * p ) { return new_short( *(const short*)p ); } /***/
void * copy_int( const void * p ) { return new_int( *(const int*)p ); } /***/
void * copy_pair_short_char( const void * p ) { return copy_pair( p, copy_short, copy_char ); } /***/
void free_pair_short_char( void * p ) { free_pair( p, free, free ); } /***/

int cmp_char( const void* a, const void* b ) { /***/
	return *(const char*)a == *(const char*)b ? 0 : *(const char*)a < *(const char*)b ? -1 : 1;
}

int cmp_short( const void* a, const void* b ) { /***/
	return *(const short*)a == *(const short*)b ? 0 : *(const short*)a < *(const short*)b ? -1 : 1; 
}

int main(int argc, char * argv[] ) {
	int maxi = 0, vali = 42;
	struct stack si = new_stack(), ti;

	REPEAT_TIMED( "push_int", N, push_stack( &si, new_int( vali ) ); )
	TIMED( "copy_int", 	copy_stack( &ti, &si, copy_int ); /***/ )
	TIMED( "clear_int", clear_stack( &si, free ); /***/ )
	REPEAT_TIMED( "pop_int", N, 
		int* xi = pop_stack( &ti );
		if ( *xi > maxi ) { maxi = *xi; }
		free(xi); )

	struct pair * maxp = new_pair( new_short(0), new_char('\0') ),
		* valp = new_pair( new_short(42), new_char('a') );
	struct stack sp = new_stack(), tp;

	REPEAT_TIMED( "push_pair", N, push_stack( &sp, copy_pair_short_char( valp ) ); )
	TIMED( "copy_pair", copy_stack( &tp, &sp, copy_pair_short_char ); /***/ )
	TIMED( "clear_pair", clear_stack( &sp, free_pair_short_char ); /***/ )
	REPEAT_TIMED( "pop_pair", N, 
		struct pair * xp = pop_stack( &tp );
		if ( cmp_pair( xp, maxp, cmp_short, cmp_char /***/ ) > 0 ) {
			free_pair_short_char( maxp ); /***/
			maxp = xp;
		} else {
			free_pair_short_char( xp ); /***/
		} )
	free_pair_short_char( maxp ); /***/
	free_pair_short_char( valp ); /***/
}
