//
// Cforall Version 1.0.0 Copyright (C) 2017 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// references.c --
//
// Author           : Rob Schluntz
// Created On       : Wed Aug 23 16:11:50 2017
// Last Modified By : Rob Schluntz
// Last Modified On : Wed Aug 23 16:12:03
// Update Count     : 2
//

struct Y { int i; };
void ?{}(Y & y) { printf("Default constructing a Y\n"); }
void ?{}(Y & y, Y other) { printf("Copy constructing a Y\n"); }
void ^?{}(Y & y) { printf("Destructing a Y\n"); }
Y ?=?(Y & y, Y other) { printf("Assigning a Y\n"); return y; }
void ?{}(Y & y, int i) { printf("Value constructing a Y %d\n", i); y.i = i; }

struct X { Y & r; Y y; };
void ?{}(X & x) {
	// ensure that r is not implicitly constructed
}
void ?{}(X & x, X other) {
	// ensure that r is not implicitly constructed
}
void ^?{}(X & x) {
	// ensure that r is not implicitly destructed
}
X ?=?(X & x, X other) { return x; }

// ensure that generated functions do not implicitly operate on references
struct Z { Y & r; Y y; };

// test user-defined reference-returning function
int & toref( int * p ) { return *p; }
// test user-defined reference-parameter function
int * toptr( int & r ) { return &r; }

void changeRef( int & r ) {
	r++;
}

// --- temporary code needed to make array of references subscript work.
extern "C" {
  void ** __index(__attribute__ ((unused)) size_t sizeof_T, __attribute__ ((unused)) size_t alignof_T, void **x, ptrdiff_t y) {
    return (void **)((char *)x+y*sizeof(void *));
  }
  void __ctor(void ***dst, void **src) {
    *dst = src;
  }
}
__attribute__((alias("__index"))) forall( dtype T | sized(T) ) T && ?[?]( T & * x, ptrdiff_t y );
__attribute__((alias("__ctor"))) forall( dtype DT ) void ?{}( DT & * & dst, DT & * src);
forall( dtype DT ) void ^?{}( DT & * & ) {}
// --- end of temporary code

int main() {
	int x = 123456, x2 = 789, *p1 = &x, **p2 = &p1, ***p3 = &p2,
		&r1 = x,    &&r2 = r1,   &&&r3 = r2;
	***p3 = 3;                          // change x
	**p3 = &x;                          // change p1
	*p3 = &p1;                          // change p2
	int y = 0, z = 11, & ar[3] = { x, y, z };    // initialize array of references
	&ar[1] = &z;                        // change reference array element
	typeof( ar[1] ) p = 3;              // is int, i.e., the type of referenced object
	typeof( &ar[1] ) q = &x;            // is int *, i.e., the type of pointer
	_Static_assert( sizeof( ar[1] ) == sizeof( int ), "Array type should be int." );   // is true, i.e., the size of referenced object
	_Static_assert( sizeof( &ar[1] ) == sizeof( int *), "Address of array should be int *." ); // is true, i.e., the size of a reference

	((int*&)&r3) = &x;                  // change r1, (&*)**r3
	x = 3;
	// test that basic reference properties are true - r1 should be an alias for x
	printf("%d %d %d\n", x, r1, &x == &r1);
	r1 = 12;
	printf("%d %d %d\n", x, r1, &x == &r1);

	// test that functions using basic references work
	printf("%d %d %d %d\n", toref(&x), toref(p1), toptr(r1) == toptr(x), toptr(r1) == &x);

	changeRef( x );
	changeRef( y );
	changeRef( z );
	printf("%d %d %d\n", x, y, z);
	changeRef( r1 );
	printf("%d %d\n", r1, x);

	r3 = 6;                               // change x, ***r3
	printf("x = %d ; x2 = %d\n", x, x2);  // check that x was changed
	&r3 = &x2;                            // change r1 to refer to x2, (&*)**r3
	r3 = 999;                             // modify x2
	printf("x = %d ; x2 = %d\n", x, x2);  // check that x2 was changed
	((int**&)&&r3) = p2;                  // change r2, (&(&*)*)*r3, ensure explicit cast to reference works
	r3 = 12345;                           // modify x
	printf("x = %d ; x2 = %d\n", x, x2);  // check that x was changed
	&&&r3 = p3;                           // change r3 to p3, (&(&(&*)*)*)r3
	((int&)r3) = 22222;                   // modify x, ensure explicit cast to reference works
	printf("x = %d ; x2 = %d\n", x, x2);  // check that x was changed

	// test that reference members are not implicitly constructed/destructed/assigned
	X x1, x2 = x1;
	x1 = x2;

	Z z1, z2 = z1;
	Y z1r = 56, z2r = 78;
	&z1.r = &z1r;
	&z2.r = &z2r;

	z1 = z2;

	// test rvalue-to-reference conversion
	{
		struct S { double x, y; };
		void f( int & i, int & j, S & s, int v[] ) {
			printf("%d %d { %g, %g }, [%d, %d, %d]\n", i, j, s.[x, y], v[0], v[1], v[2]);
		}
		void g(int & i) { printf("%d\n", i); }
		void h(int &&& i) { printf("%d\n", i); }

		int &&& r = 3;  // rvalue to reference
		int i = r;
		printf("%d %d\n", i, r);  // both 3

		g( 3 );          // rvalue to reference
		h( (int &&&)3 ); // rvalue to reference

		int a = 5, b = 4;
		f( 3, a + b, (S){ 1.0, 7.0 }, (int [3]){ 1, 2, 3 } ); // two rvalue to reference
	}
}

// Local Variables: //
// tab-width: 4 //
// End: //

