// 
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// defs.h -- 
// 
// Author           : Thierry Delisle
// Created On       : Thu Nov  9 13:24:10 2017
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jan  2 09:17:06 2018
// Update Count     : 2
// 

#pragma once

#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>

#define likely(x)   __builtin_expect(!!(x), 1)
#define unlikely(x) __builtin_expect(!!(x), 0)
#define thread_local _Thread_local

typedef void (*fptr_t)();
typedef int_fast16_t __lock_size_t;

#ifdef __cforall
#define __cfa_anonymous_object
#else
#define __cfa_anonymous_object __cfa_anonymous_object
#endif

#ifdef __cforall
extern "C" {
#endif
void abortf( const char fmt[], ... ) __attribute__ ((__nothrow__, __leaf__, __noreturn__));
#ifdef __cforall
}
#endif
