//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// iostream.c -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed May 27 18:18:13 2015
// Update Count     : 2
//

#include "iostream.h"
extern "C" {
#include <stdio.h>
//#include <string.h>
//#include <ctype.h>
	typedef long unsigned int size_t;
	size_t strlen(const char *s);
}

forall( dtype ostype | ostream( ostype ) )
ostype * ?<<?( ostype *os, char c ) {
	return write( os, &c, 1 );
}

forall( dtype ostype | ostream( ostype ) )
ostype * ?<<?( ostype *os, int i ) {
	char buffer[20];      // larger than the largest integer
	sprintf( buffer, "%d", i );
	return write( os, buffer, strlen( buffer ) );
}

forall( dtype ostype | ostream( ostype ) )
ostype * ?<<?( ostype *os, double d ) {
	char buffer[32];      // larger than the largest double
	sprintf( buffer, "%g", d );
	return write( os, buffer, strlen( buffer ) );
}

forall( dtype ostype | ostream( ostype ) )
ostype * ?<<?( ostype *os, const char *cp ) {
	return write( os, cp, strlen( cp ) );
}

forall( dtype istype | istream( istype ) )
istype * ?>>?( istype *is, char *cp ) {
	return read( is, cp, 1 );
}

forall( dtype istype | istream( istype ) )
istype * ?>>?( istype *is, int *ip ) {
	char cur;
  
	// skip some whitespace
	do {
		is >> &cur;
		if ( fail( is ) || eof( is ) ) return is;
	} while ( !( cur >= '0' && cur <= '9' ) );
  
	// accumulate digits
	*ip = 0;
	while ( cur >= '0' && cur <= '9' ) {
		*ip = *ip * 10 + ( cur - '0' );
		is >> &cur;
		if ( fail( is ) || eof( is ) ) return is;
	}
  
	unread( is, cur );
	return is;
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa iostream.c" //
// End: //
