
#include <stdbool.h>
#include <stdlib.h>
#include <stdio.h>

#include "libhdr.h"
#include "invoke.h"

#define __CFA_INVOKE_PRIVATE__
#include "invoke.h"

// magically invoke the "main" of the most derived class
// Called from the kernel when starting a coroutine or task so must switch back to user mode.

extern void __suspend_no_inline__F___1(void);

void CtxInvokeCoroutine(
      void (*main)(void *), 
      struct coroutine *(*get_coroutine)(void *), 
      void *this
) {
      LIB_DEBUG_PRINTF("Invoke : Received %p (main %p, get_c %p)\n", this, main, get_coroutine);

      struct coroutine* cor = get_coroutine( this );

      if(cor->state == Primed) {
            __suspend_no_inline__F___1();
      }

      cor->state = Active;

      main( this );
}


void CtxStart(
      void (*main)(void *), 
      struct coroutine *(*get_coroutine)(void *), 
      void *this, 
      void (*invoke)(void *)
) {
      LIB_DEBUG_PRINTF("StartCoroutine : Passing in %p (main %p, get_c %p) to %p\n", this, main, get_coroutine, invoke);

      struct coStack_t* stack = &get_coroutine( this )->stack;

#if defined( __i386__ )

	struct FakeStack {
	    void *fixedRegisters[3];		  	// fixed registers ebx, edi, esi (popped on 1st uSwitch, values unimportant)
	    void *rturn;				      // where to go on return from uSwitch
	    void *dummyReturn;				// fake return compiler would have pushed on call to uInvoke
	    void *argument[3];				// for 16-byte ABI, 16-byte alignment starts here
	    void *padding;				// padding to force 16-byte alignment, as "base" is 16-byte aligned
	};

	((struct machine_context_t *)stack->context)->SP = (char *)stack->base - sizeof( struct FakeStack );
	((struct machine_context_t *)stack->context)->FP = NULL;		// terminate stack with NULL fp

	((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->dummyReturn = NULL;
	((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->argument[0] = this;     // argument to invoke
	((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->rturn = invoke;

#elif defined( __x86_64__ )

      struct FakeStack {
            void *fixedRegisters[5];			// fixed registers rbx, r12, r13, r14, r15
            void *rturn;					// where to go on return from uSwitch
            void *dummyReturn;				// NULL return address to provide proper alignment
      };

      ((struct machine_context_t *)stack->context)->SP = (char *)stack->base - sizeof( struct FakeStack );
      ((struct machine_context_t *)stack->context)->FP = NULL;		// terminate stack with NULL fp

      ((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->dummyReturn = NULL;
      ((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->rturn = CtxInvokeStub;
      ((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->fixedRegisters[0] = this;
      ((struct FakeStack *)(((struct machine_context_t *)stack->context)->SP))->fixedRegisters[1] = invoke;
#else
      #error Only __i386__ and __x86_64__ is supported for threads in cfa
#endif
}
