//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// FixFunction.cc --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 16:19:49 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Mar  6 23:36:59 2017
// Update Count     : 6
//

#include "FixFunction.h"

#include <list>                   // for list

#include "Common/utility.h"       // for maybeClone
#include "SynTree/Declaration.h"  // for FunctionDecl, ObjectDecl, Declarati...
#include "SynTree/Expression.h"   // for Expression
#include "SynTree/Type.h"         // for ArrayType, PointerType, Type, Basic...

namespace SymTab {
	FixFunction::FixFunction() : isVoid( false ) {}


	DeclarationWithType * FixFunction::postmutate(FunctionDecl *functionDecl) {
		// can't delete function type because it may contain assertions, so transfer ownership to new object
		ObjectDecl *pointer = new ObjectDecl( functionDecl->name, functionDecl->get_storageClasses(), functionDecl->linkage, nullptr, new PointerType( Type::Qualifiers(), functionDecl->type ), nullptr, functionDecl->attributes );
		functionDecl->attributes.clear();
		functionDecl->type = nullptr;
		delete functionDecl;
		return pointer;
	}

	// xxx - this passes on void[], e.g.
	//   void foo(void [10]);
	// does not cause an error

	Type * FixFunction::postmutate(ArrayType *arrayType) {
		// need to recursively mutate the base type in order for multi-dimensional arrays to work.
		PointerType *pointerType = new PointerType( arrayType->get_qualifiers(), arrayType->base, arrayType->dimension, arrayType->isVarLen, arrayType->isStatic );
		arrayType->base = nullptr;
		arrayType->dimension = nullptr;
		delete arrayType;
		return pointerType;
	}

	void FixFunction::premutate(VoidType *) {
		isVoid = true;
	}

	void FixFunction::premutate(FunctionDecl *) { visit_children = false; }
	void FixFunction::premutate(ArrayType *) { visit_children = false; }
	void FixFunction::premutate(BasicType *) { visit_children = false; }
	void FixFunction::premutate(PointerType *) { visit_children = false; }
	void FixFunction::premutate(StructInstType *) { visit_children = false; }
	void FixFunction::premutate(UnionInstType *) { visit_children = false; }
	void FixFunction::premutate(EnumInstType *) { visit_children = false; }
	void FixFunction::premutate(TraitInstType *) { visit_children = false; }
	void FixFunction::premutate(TypeInstType *) { visit_children = false; }
	void FixFunction::premutate(TupleType *) { visit_children = false; }
	void FixFunction::premutate(VarArgsType *) { visit_children = false; }
	void FixFunction::premutate(ZeroType *) { visit_children = false; }
	void FixFunction::premutate(OneType *) { visit_children = false; }

	bool fixFunction( DeclarationWithType *& dwt ) {
		PassVisitor<FixFunction> fixer;
		dwt = dwt->acceptMutator( fixer );
		return fixer.pass.isVoid;
	}
} // namespace SymTab

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
