//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// CtxSwitch-i386.S --
//
// Author           : Thierry Delisle
// Created On       : Tue Dec 6 12:27:26 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Sep  6 18:23:37 2020
// Update Count     : 5
//

// The context switch routine requires the initial the stack of a thread to
// look like the thread has saved its context in the normal manner.

// Offsets must synchronized with the __stack_context_t in invoke.h.

#define PTR_BYTE	4
#define SP_OFFSET	( 0 * PTR_BYTE )
#define FP_OFFSET	( 1 * PTR_BYTE )

// Context switch between coroutines/tasks.
//   void __cfactx_switch( struct __stack_context_t * from, struct __stack_context_t * to ) ;
// Arguments "from" in register 4(%esp), "to" in register 20(%esp)

	.file "CtxSwitch-i386.S"
	.text
	.align 2
	.global __cfactx_switch
	.type __cfactx_switch, @function
__cfactx_switch:

	// Copy the "from" context argument from the stack to register eax
	// Return address is at 0(%esp), with parameters following.

	movl 4(%esp),%eax

	// Save volatile registers on the stack.

	pushl %ebx
	pushl %edi
	pushl %esi

	// Save old context in the "from" area.

	movl %esp,SP_OFFSET(%eax)
	movl %ebp,FP_OFFSET(%eax)

	// Copy the "to" context argument from the stack to register eax. Having
	// pushed 3 words (= 12 bytes) on the stack, the argument is now at
	// 8 + 12 = 20(%esp).

	movl 20(%esp),%eax

	// Load new context from the "to" area.

	movl SP_OFFSET(%eax),%esp
	movl FP_OFFSET(%eax),%ebp

	// Load volatile registers from the stack.

	popl %esi
	popl %edi
	popl %ebx

	// Return to thread.

	ret
	.size __cfactx_switch, .-__cfactx_switch

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
