class Monitor {
	public static volatile Boolean go = false;
}

class Signaller extends Thread {
	Monitor m;
	Signaller(Monitor m) {
		this.m = m;
	}

	public void run() {
		Monitor.go = true;
		while( Monitor.go ) {
			synchronized(this.m) {
				this.m.notify();
			}
		}
	}
}

public class JavaThread {
	public static void main(String[] args) throws InterruptedException {
		int NoOfTimes = 50000;
		Monitor m = new Monitor();
		long start, end;
		Signaller s = new Signaller(m);
		synchronized(m) {
			s.start();
			while( !Monitor.go ) {
				Thread.yield();
			}
			start = System.nanoTime();
			for(int i = 1; i <= NoOfTimes; i += 1) {
				m.wait();
			}
			end = System.nanoTime();
		}
		Monitor.go = false;
		s.join();
		System.out.println( (end - start) / NoOfTimes);
	}
}