// 
// Cforall Version 1.0.0 Copyright (C) 2017 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// pingpong.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Sep 20 11:55:23 2017
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Sep 20 13:41:39 2017
// Update Count     : 26
// 

#include <coroutine>
#include <fstream>

coroutine PingPong {
	const char * name;
	/* const */ unsigned int N;
	PingPong * part;
};

void ?{}( PingPong & this, const char * name, unsigned int N, PingPong & part ) {
	this.name = name;
	this.N = N;
	this.part = &part;
}
void ?{}( PingPong & this, const char * name, unsigned int N ) {
	this{ name, N, *(PingPong *)0 };
}
void cycle( PingPong & pingpong ) {
	resume( pingpong );
}
void partner( PingPong & this, PingPong & part ) {
	this.part = &part;
	resume( this );
}
void main( PingPong & pingpong ) {						// ping's starter ::main, pong's starter ping
	for ( unsigned int i = 0; i < pingpong.N; i += 1 ) {
		sout | pingpong.name | endl;
		cycle( *pingpong.part );
	} // for
}
int main() {
	enum { N = 20 };
	PingPong ping = { "ping", N }, pong = { "pong", N, ping };
	partner( ping, pong );
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa pingpong.c" //
// End: //
