//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// FixFunction.h --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 17:02:08 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 09:45:55 2017
// Update Count     : 4
//

#pragma once

#include "SynTree/Mutator.h"  // for Mutator
#include "SynTree/SynTree.h"  // for Types

namespace SymTab {
	/// Replaces function and array types by equivalent pointer types.
	class FixFunction : public Mutator {
		typedef Mutator Parent;
	  public:
		FixFunction();

		bool get_isVoid() const { return isVoid; }
		void set_isVoid( bool newValue ) { isVoid = newValue; }
	  private:
		virtual DeclarationWithType* mutate(FunctionDecl *functionDecl);

		virtual Type* mutate(VoidType *voidType);
		virtual Type* mutate(BasicType *basicType);
		virtual Type* mutate(PointerType *pointerType);
		virtual Type* mutate(ArrayType *arrayType);
		virtual Type* mutate(StructInstType *aggregateUseType);
		virtual Type* mutate(UnionInstType *aggregateUseType);
		virtual Type* mutate(EnumInstType *aggregateUseType);
		virtual Type* mutate(TraitInstType *aggregateUseType);
		virtual Type* mutate(TypeInstType *aggregateUseType);
		virtual Type* mutate(TupleType *tupleType);
		virtual Type* mutate(VarArgsType *varArgsType);
		virtual Type* mutate(ZeroType *zeroType);
		virtual Type* mutate(OneType *oneType);

		bool isVoid;
	};
} // namespace SymTab

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
