//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Declaration.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
<<<<<<< Updated upstream
// Last Modified By : Rob Schluntz
// Last Modified On : Mon May 25 13:54:32 2015
=======
// Last Modified By : Rob Schluntz
// Last Modified On : Thu May 21 16:27:31 2015
>>>>>>> Stashed changes
// Update Count     : 5
//

#ifndef DECLARATION_H
#define DECLARATION_H

#include "SynTree.h"
#include "Visitor.h"
#include "Mutator.h"
#include "Parser/LinkageSpec.h"

class Declaration {
  public:
	enum StorageClass {  
		NoStorageClass,
		Extern,
		Static,
		Auto,
		Register,
		Inline,
		Fortran,
	};	

	Declaration( const std::string &name, StorageClass sc, LinkageSpec::Type linkage );
	Declaration( const Declaration &other );
	virtual ~Declaration();

	std::string get_name() const { return name; }
	void set_name( std::string newValue ) { name = newValue; }
	StorageClass get_storageClass() const { return storageClass; }
	void set_storageClass( StorageClass newValue ) { storageClass = newValue; }
	LinkageSpec::Type get_linkage() const { return linkage; }
	void set_linkage( LinkageSpec::Type newValue ) { linkage = newValue; }
	UniqueId get_uniqueId() const { return uniqueId; }

	void fixUniqueId( void );
	virtual Declaration *clone() const = 0;
	virtual void accept( Visitor &v ) = 0;
	virtual Declaration *acceptMutator( Mutator &m ) = 0;
	virtual void print( std::ostream &os, int indent = 0 ) const = 0;
	virtual void printShort( std::ostream &os, int indent = 0 ) const = 0;

	static const char* storageClassName[];  

	static void dumpIds( std::ostream &os );
	static Declaration *declFromId( UniqueId id );
  private:
	std::string name;
	StorageClass storageClass;
	LinkageSpec::Type linkage;
	UniqueId uniqueId;
};

class DeclarationWithType : public Declaration {
  public:
	DeclarationWithType( const std::string &name, StorageClass sc, LinkageSpec::Type linkage );
	DeclarationWithType( const DeclarationWithType &other );
	virtual ~DeclarationWithType();

	std::string get_mangleName() const { return mangleName; }
	void set_mangleName( std::string newValue ) { mangleName = newValue; }

	virtual DeclarationWithType *clone() const = 0;
	virtual DeclarationWithType *acceptMutator( Mutator &m ) = 0;

	virtual Type *get_type() const = 0;
	virtual void set_type(Type *) = 0;
  private:
	// this represents the type with all types and typedefs expanded it is generated by SymTab::Validate::Pass2
	std::string mangleName;
};

class ObjectDecl : public DeclarationWithType {
	typedef DeclarationWithType Parent;
  public:
	ObjectDecl( const std::string &name, StorageClass sc, LinkageSpec::Type linkage, Expression *bitfieldWidth, Type *type, Initializer *init );
	ObjectDecl( const ObjectDecl &other );
	virtual ~ObjectDecl();

	virtual Type *get_type() const { return type; }
	virtual void set_type(Type *newType) { type = newType; }

	Initializer *get_init() const { return init; }
	void set_init( Initializer *newValue ) { init = newValue; }
	Expression *get_bitfieldWidth() const { return bitfieldWidth; }
	void set_bitfieldWidth( Expression *newValue ) { bitfieldWidth = newValue; }

	virtual ObjectDecl *clone() const { return new ObjectDecl( *this ); }
	virtual void accept( Visitor &v ) { v.visit( this ); }
	virtual ObjectDecl *acceptMutator( Mutator &m ) { return m.mutate( this ); }
	virtual void print( std::ostream &os, int indent = 0 ) const;
	virtual void printShort( std::ostream &os, int indent = 0 ) const;
  private:
	Type *type;
	Initializer *init;
	Expression *bitfieldWidth;
};

class FunctionDecl : public DeclarationWithType {
	typedef DeclarationWithType Parent;
  public:
	FunctionDecl( const std::string &name, StorageClass sc, LinkageSpec::Type linkage, FunctionType *type, CompoundStmt *statements, bool isInline );
	FunctionDecl( const FunctionDecl &other );
	virtual ~FunctionDecl();

	Type *get_type() const;
	virtual void set_type(Type *);

	FunctionType *get_functionType() const { return type; }
	void set_functionType( FunctionType *newValue ) { type = newValue; }
	CompoundStmt *get_statements() const { return statements; }
	void set_statements( CompoundStmt *newValue ) { statements = newValue; }
	bool get_isInline() const { return isInline; }
//	void set_isInline( bool newValue ) { isInline = newValue; }
	std::list< std::string >& get_oldIdents() { return oldIdents; }
	std::list< Declaration* >& get_oldDecls() { return oldDecls; }

	virtual FunctionDecl *clone() const { return new FunctionDecl( *this ); }
	virtual void accept( Visitor &v ) { v.visit( this ); }
	virtual DeclarationWithType *acceptMutator( Mutator &m ) { return m.mutate( this ); }
	virtual void print( std::ostream &os, int indent = 0 ) const;
	virtual void printShort( std::ostream &os, int indent = 0 ) const;
  private:
	FunctionType *type;
	CompoundStmt *statements;
	bool isInline;
	std::list< std::string > oldIdents;
	std::list< Declaration* > oldDecls;
};

class NamedTypeDecl : public Declaration {
	typedef Declaration Parent;
  public:
	NamedTypeDecl( const std::string &name, StorageClass sc, Type *type );
	NamedTypeDecl( const TypeDecl &other );
	virtual ~NamedTypeDecl();

	Type *get_base() const { return base; }
	void set_base( Type *newValue ) { base = newValue; }
	std::list< TypeDecl* >& get_parameters() { return parameters; }
	std::list< DeclarationWithType* >& get_assertions() { return assertions; }

	virtual NamedTypeDecl *clone() const = 0;
	virtual void print( std::ostream &os, int indent = 0 ) const;
	virtual void printShort( std::ostream &os, int indent = 0 ) const;
  protected:
	virtual std::string typeString() const = 0;
  private:
	Type *base;
	std::list< TypeDecl* > parameters;
	std::list< DeclarationWithType* > assertions;
};

class TypeDecl : public NamedTypeDecl {
	typedef NamedTypeDecl Parent;
  public:
	enum Kind { Any, Dtype, Ftype };

	TypeDecl( const std::string &name, StorageClass sc, Type *type, Kind kind );
	TypeDecl( const TypeDecl &other );

	Kind get_kind() const { return kind; }

	virtual TypeDecl *clone() const { return new TypeDecl( *this ); }
	virtual void accept( Visitor &v ) { v.visit( this ); }
	virtual TypeDecl *acceptMutator( Mutator &m ) { return m.mutate( this ); }
  private:
	virtual std::string typeString() const;
	Kind kind;
};

class TypedefDecl : public NamedTypeDecl {
	typedef NamedTypeDecl Parent;
  public:
	TypedefDecl( const std::string &name, StorageClass sc, Type *type ) : Parent( name, sc, type ) {}
	TypedefDecl( const TypedefDecl &other ) : Parent( other ) {}

	virtual TypedefDecl *clone() const { return new TypedefDecl( *this ); }
	virtual void accept( Visitor &v ) { v.visit( this ); }
	virtual Declaration *acceptMutator( Mutator &m ) { return m.mutate( this ); }
  private:
	virtual std::string typeString() const;
};

class AggregateDecl : public Declaration {
	typedef Declaration Parent;
  public:
	AggregateDecl( const std::string &name );
	AggregateDecl( const AggregateDecl &other );
	virtual ~AggregateDecl();

	std::list<Declaration*>& get_members() { return members; }
	std::list<TypeDecl*>& get_parameters() { return parameters; }

	virtual void print( std::ostream &os, int indent = 0 ) const;
	virtual void printShort( std::ostream &os, int indent = 0 ) const;
  protected:
	virtual std::string typeString() const = 0;

  private:
	std::list<Declaration*> members;
	std::list<TypeDecl*> parameters;
};

class StructDecl : public AggregateDecl {
	typedef AggregateDecl Parent;
  public:
	StructDecl( const std::string &name ) : Parent( name ) {}
	StructDecl( const StructDecl &other ) : Parent( other ) {}

	virtual StructDecl *clone() const { return new StructDecl( *this ); }
	virtual void accept( Visitor &v ) { v.visit( this ); }
	virtual Declaration *acceptMutator( Mutator &m ) { return m.mutate( this ); }

  private:
	virtual std::string typeString() const;
};

class UnionDecl : public AggregateDecl {
	typedef AggregateDecl Parent;
  public:
	UnionDecl( const std::string &name ) : Parent( name ) {}
	UnionDecl( const UnionDecl &other ) : Parent( other ) {}

	virtual UnionDecl *clone() const { return new UnionDecl( *this ); }
	virtual void accept( Visitor &v ) { v.visit( this ); }
	virtual Declaration *acceptMutator( Mutator &m ) { return m.mutate( this ); }
  private:
	virtual std::string typeString() const;
};

class EnumDecl : public AggregateDecl {
	typedef AggregateDecl Parent;
  public:
	EnumDecl( const std::string &name ) : Parent( name ) {}
	EnumDecl( const EnumDecl &other ) : Parent( other ) {}

	virtual EnumDecl *clone() const { return new EnumDecl( *this ); }
	virtual void accept( Visitor &v ) { v.visit( this ); }
	virtual Declaration *acceptMutator( Mutator &m ) { return m.mutate( this ); }
  private:
	virtual std::string typeString() const;
};

class ContextDecl : public AggregateDecl {
	typedef AggregateDecl Parent;
  public:
	ContextDecl( const std::string &name ) : Parent( name ) {}
	ContextDecl( const ContextDecl &other ) : Parent( other ) {}

	virtual ContextDecl *clone() const { return new ContextDecl( *this ); }
	virtual void accept( Visitor &v ) { v.visit( this ); }
	virtual Declaration *acceptMutator( Mutator &m ) { return m.mutate( this ); }
  private:
	virtual std::string typeString() const;
};

#endif // DECLARATION_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
