#if !defined(WITH_PTHREADS) && !defined(WITH_LIBFIBRE) && !defined(WITH_CFORALL)
#error must define WITH_PTHREADS, WITH_LIBFIBRE or WITH_CFORALL
#endif

#ifdef WITH_PTHREADS
#include "pthread.hpp"
#endif
#ifdef WITH_LIBFIBRE
#include "fibre.hpp"
#endif
#ifdef WITH_CFORALL
#include "cforall.hpp"
#endif

namespace thrdlib {
	//--------------------
	// Basic thread support
	void * create( void (*main)( void * ) ) { return (thread_t)thrdlib_create(  (void (*)( thread_t )) main ); }
	void join  ( void * handle ) { thrdlib_join  ((thread_t)handle); }
	void park  ( void * handle ) { thrdlib_park  ((thread_t)handle); }
	void unpark( void * handle ) { thrdlib_unpark((thread_t)handle); }
	void yield( void )  { thrdlib_yield(); }

	//--------------------
	// Basic kernel features
	void init( int procs ) { thrdlib_init(procs); }
	void clean( void ) { thrdlib_clean(); }
};