#include <pthread.h>
#include <stdio.h>
#include <stdbool.h>

#include "../bench.h"

pthread_mutex_t mutex;

volatile bool go = false;

void call() {
	go = true;
	for ( size_t i = 0; i < times; i += 1 ) {
		pthread_mutex_lock( &mutex );
		pthread_mutex_unlock( &mutex );
	}
	go = false;
}
void * thread_main( __attribute__((unused)) void * arg ) {
	while ( ! go );
	while ( go ) {
		pthread_mutex_lock( &mutex );
		pthread_mutex_unlock( &mutex );
	}
	return NULL;
}
int main( int argc, char * argv[] ) {
	BENCH_START()
	pthread_t thread;
	if ( pthread_create( &thread, NULL, thread_main, NULL ) < 0 ) {
		perror( "failure" );
		return EXIT_FAILURE;
	}
	BENCH(
		call(),
		result
	)
	printf( "%g\n", result );
	if ( pthread_join( thread, NULL ) < 0 ) {
		perror( "failure" );
		return EXIT_FAILURE;
	}
}

// Local Variables: //
// tab-width: 4 //
// End: //
