//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// invoke.h --
//
// Author           : Thierry Delisle
// Created On       : Tue Jan 17 12:27:26 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Jul 21 22:28:56 2017
// Update Count     : 1
//

#include <stdbool.h>
#include <stdint.h>

#ifdef __CFORALL__
extern "C" {
#endif

#if ! defined(__CFA_INVOKE_PRIVATE__)
#ifndef _INVOKE_H_
#define _INVOKE_H_

	#define unlikely(x)    __builtin_expect(!!(x), 0)
	#define thread_local _Thread_local

	typedef void (*fptr_t)();
	typedef int_fast16_t __lock_size_t;

	struct spinlock {
		volatile int lock;
		#ifdef __CFA_DEBUG__
			const char * prev_name;
			void* prev_thrd;
		#endif
	};

	struct __thread_queue_t {
		struct thread_desc * head;
		struct thread_desc ** tail;
	};

	struct __condition_stack_t {
		struct __condition_criterion_t * top;
	};

	#ifdef __CFORALL__
	extern "Cforall" {
		void ?{}( struct __thread_queue_t & );
		void append( struct __thread_queue_t &, struct thread_desc * );
		struct thread_desc * pop_head( struct __thread_queue_t & );
		struct thread_desc * remove( struct __thread_queue_t &, struct thread_desc ** );

		void ?{}( struct __condition_stack_t & );
		void push( struct __condition_stack_t &, struct __condition_criterion_t * );
		struct __condition_criterion_t * pop( struct __condition_stack_t & );

		void  ?{}(spinlock & this);
		void ^?{}(spinlock & this);
	}
	#endif

	struct coStack_t {
		// size of stack
		unsigned int size;

		// pointer to stack
		void *storage;

		// stack grows towards stack limit
		void *limit;

		// base of stack
		void *base;

		// address of cfa_context_t
		void *context;

		// address of top of storage
		void *top;

		// whether or not the user allocated the stack
		bool userStack;

	};

	enum coroutine_state { Halted, Start, Inactive, Active, Primed };

	struct coroutine_desc {
		// stack information of the coroutine
		struct coStack_t stack;

		// textual name for coroutine/task, initialized by uC++ generated code
		const char *name;

		// copy of global UNIX variable errno
		int errno_;

		// current execution status for coroutine
		enum coroutine_state state;

		// first coroutine to resume this one
		struct coroutine_desc * starter;

		// last coroutine to resume this one
		struct coroutine_desc * last;
	};

	struct __waitfor_mask_t {
		// the index of the accepted function, -1 if none
		short * accepted;

		// list of acceptable functions, null if any
		struct __acceptable_t * clauses;

		// number of acceptable functions
		short size;
	};

	struct monitor_desc {
		// spinlock to protect internal data
		struct spinlock lock;

		// current owner of the monitor
		struct thread_desc * owner;

		// queue of threads that are blocked waiting for the monitor
		struct __thread_queue_t entry_queue;

		// stack of conditions to run next once we exit the monitor
		struct __condition_stack_t signal_stack;

		// monitor routines can be called recursively, we need to keep track of that
		unsigned int recursion;

		// mask used to know if some thread is waiting for something while holding the monitor
		struct __waitfor_mask_t mask;

		// node used to signal the dtor in a waitfor dtor
		struct __condition_node_t * dtor_node;
	};

	struct __monitor_group_t {
		// currently held monitors
		struct monitor_desc ** list;

		// number of currently held monitors
		short                  size;

		// last function that acquired monitors
		fptr_t                 func;
	};

	struct thread_desc {
		// Core threading fields
		// coroutine body used to store context
		struct coroutine_desc  self_cor;

		// monitor body used for mutual exclusion
		struct monitor_desc    self_mon;

		// pointer to monitor with sufficient lifetime for current monitors
		struct monitor_desc *  self_mon_p;

		// monitors currently held by this thread
		struct __monitor_group_t monitors;


		// Link lists fields
		// instrusive link field for threads
		struct thread_desc * next;
     };

     #ifdef __CFORALL__
     extern "Cforall" {
		static inline monitor_desc * ?[?]( const __monitor_group_t & this, ptrdiff_t index ) {
			return this.list[index];
		}

		static inline bool ?==?( const __monitor_group_t & lhs, const __monitor_group_t & rhs ) {
			if( (lhs.list != 0) != (rhs.list != 0) ) return false;
			if( lhs.size != rhs.size ) return false;
			if( lhs.func != rhs.func ) return false;

			// Check that all the monitors match
			for( int i = 0; i < lhs.size; i++ ) {
				// If not a match, check next function
				if( lhs[i] != rhs[i] ) return false;
			}

			return true;
		}
	}
	#endif

#endif //_INVOKE_H_
#else //! defined(__CFA_INVOKE_PRIVATE__)
#ifndef _INVOKE_PRIVATE_H_
#define _INVOKE_PRIVATE_H_

	struct machine_context_t {
		void *SP;
		void *FP;
		void *PC;
	};

	// assembler routines that performs the context switch
	extern void CtxInvokeStub( void );
	void CtxSwitch( void * from, void * to ) asm ("CtxSwitch");

	#if   defined( __x86_64__ )
	#define CtxGet( ctx ) __asm__ ( \
			"movq %%rsp,%0\n"   \
			"movq %%rbp,%1\n"   \
		: "=rm" (ctx.SP), "=rm" (ctx.FP) )
	#elif defined( __i386__ )
	#define CtxGet( ctx ) __asm__ ( \
			"movl %%esp,%0\n"   \
			"movl %%ebp,%1\n"   \
		: "=rm" (ctx.SP), "=rm" (ctx.FP) )
	#endif

#endif //_INVOKE_PRIVATE_H_
#endif //! defined(__CFA_INVOKE_PRIVATE__)
#ifdef __CFORALL__
}
#endif

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
