//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// LabelGenerator.h -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Wed Jun 03 14:16:26 2015
// Update Count     : 5
//

#ifndef LABEL_GENERATOR_H
#define LABEL_GENERATOR_H

#include "SynTree/SynTree.h"
#include <string>

namespace ControlStruct {
	class LabelGenerator {
	  public:
		static LabelGenerator *getGenerator();
		Label newLabel(std::string suffix = "");
		void reset() { current = 0; }
		void rewind() { current--; }
	  protected:
		LabelGenerator(): current(0) {}
	  private:
		int current;
		static LabelGenerator *labelGenerator;
	};
} // namespace ControlStruct

#endif // LABEL_GENERATOR_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
