//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// libcfa_vector.c --
//
// Author           : Thierry Delisle
// Created On       : Mon Jul  4 23:36:19 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jul  5 15:08:05 2016
// Update Count     : 26
//

#include <fstream>
#include <vector>

#undef assert
#define assert(x)								\
	do {										\
		if ( !(x) ) {							\
			sout | "CHECK failed :" | #x | "at" | __FILE__ | " :" | __LINE__ | endl;	\
			abort();							\
		}										\
	} while( 0 == 1 )

int main() {
	vector( int, heap_allocator(int) ) iv;

	assert( empty( &iv ) );
	assert( size( &iv ) == 0 );
	sout | size( &iv ) | endl;

	push_back( &iv, 1 );
	assert( size( &iv ) == 1 );
	sout | size( &iv ) | endl;

	push_back( &iv, 2 );
	assert( size( &iv ) == 2 );
	sout | size( &iv ) | endl;

	push_back( &iv, 3 );
	assert( size( &iv ) == 3 );
	sout | size( &iv ) | endl;

	assert( !empty( &iv ) );
	assert( size( &iv ) == 3 );
	assert( at( &iv, 0 ) == 1 );
	assert( (&iv)[0] == 1 );
	assert( at( &iv, 1 ) == 2 );
	assert( (&iv)[1] == 2 );
	assert( at( &iv, 2 ) == 3 );
	assert( (&iv)[2] == 3 );

	clear( &iv );

	assert( empty( &iv ) );
	assert( size( &iv ) == 0 );
	sout | size( &iv ) | endl;
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa libcfa_vector.c" //
// End: //
