//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// AggregateTable.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 16:17:26 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Mar  2 17:31:00 2016
// Update Count     : 5
//

#ifndef AGGREGATETABLE_H
#define AGGREGATETABLE_H

#include <map>
#include <stack>
#include <string>
#include <functional>

#include "StackTable.h"
#include "SynTree/Declaration.h"

namespace SymTab {
	template< class AggregateDeclClass >
	class AggregateTableConflictFunction : public std::binary_function< AggregateDeclClass *, AggregateDeclClass *, AggregateDeclClass *> {
	  public:
		AggregateDeclClass *operator()( AggregateDeclClass *existing, AggregateDeclClass *added ) {
			if ( existing->get_members().empty() ) {
				return added;
			} else if ( ! added->get_members().empty() ) {
				throw SemanticError( "redeclaration of ", added );
			} // if
			return existing;
		}
	};

	typedef StackTable< StructDecl, AggregateTableConflictFunction< StructDecl > > StructTable;
	typedef StackTable< EnumDecl, AggregateTableConflictFunction< EnumDecl > > EnumTable;
	typedef StackTable< UnionDecl, AggregateTableConflictFunction< UnionDecl > > UnionTable;
	typedef StackTable< TraitDecl, AggregateTableConflictFunction< TraitDecl > > TraitTable;
} // namespace SymTab

#endif // AGGREGATETABLE_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
