// overloading on return type
func random() -> Int{ 3; }
func random() -> String{ "abc"; }
func random() -> Double{ 3.5; }
var r1 : Int = random();
print( r1 );
var r2 : String = random();
print( r2 );
var r3 : Double = random();
print( r3 );

// overloading functions without parameter names
func fun( _ x : Int ) -> Int{ 3; }
func fun( _ x : Int, _ y : Int ) -> Int{ x + y; }
func fun( _ x : String ) -> String{ "abc"; }
print( fun( 3, 4 ) );
// print( fun( 3.5 ) ); // no Double -> Int
//print( fun( r3 ) ); // no, Double -> Int

// overloading on parameter name
func foo( x : Int ) -> Int{ 3; }
func foo( y : Int ) -> Int{ 3; }
print( foo( x : 3 ) );
print( foo( y : 3 ) );

// overloading on generics
func bar<T>( _ a : T ) { print( "bar1", a ); }
func bar<T>( _ a : T, _ b : T ) { print( "bar2", a, b ); }
func bar<T,U>( _ a : T, _ b :  U) { print( "bar3", a, b ); }
bar( 3 );
bar( 3.5 );
bar( 2, 2 );
bar( 2, 2.5 );

// Local Variables: //
// compile-command: "swift test.swift" //
// End: //
