//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// CaseRangeMutator.h -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jul 12 17:35:30 2016
// Update Count     : 4
//

#ifndef CASERNG_MUTATOR_H
#define CASERNG_MUTATOR_H

#include <list>

#include "SynTree/Mutator.h"

namespace ControlStruct {
	/// expand case ranges and turn fallthru into a null statement
	class CaseRangeMutator : public Mutator {
	  public:
		CaseRangeMutator() {}

		virtual Statement *mutate( SwitchStmt * );
		virtual Statement *mutate( CaseStmt * );
	  private:
		void fillRange( Expression *lo, Expression *hi );

		Expression *currentCondition;
		std::list< Expression * > newCaseLabels;
	};
} // namespace ControlStruct

#endif // CASERNG_MUTATOR_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
