# set terminal pdfcairo linewidth 3 size 6,3
# set output "per-prob-histo.pdf"
set terminal pslatex size 6.25,2.125 color solid
set output BUILD."per-prob-histo.tex"

set linetype 1 lc rgb 'black'
set linetype 2 lc rgb 'red'
set linetype 3 lc rgb 'blue'
set linetype 4 lc rgb 'green'

set style data histogram
set style histogram cluster # gap 2
set style fill pattern 4 border lt -1

set xlabel "expression time (ms)"
set xtics nomirror

set ylabel "count"
set logscale y
set format y "$%.0f$"
set ytics autofreq nomirror

set y2label "ms"
set logscale y2
set format y2 "$%.0f$"
set y2tics autofreq nomirror

plot 'evaluation/per-prob.tsv' using 2:xticlabels(1) title 'expressions (count)',\
     'evaluation/per-prob.tsv' using (column(3)/1000):xticlabels(1) title 'total time (ms)' axes x1y2
