//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Type.hpp --
//
// Author           : Aaron B. Moss
// Created On       : Thu May 9 10:00:00 2019
// Last Modified By : Aaron B. Moss
// Last Modified On : Thu May 9 10:00:00 2019
// Update Count     : 1
//

#pragma once

#include "Node.hpp"

namespace ast {

class Type : public Node {

};



//=================================================================================================
/// This disgusting and giant piece of boiler-plate is here to solve a cyclic dependency
/// remove only if there is a better solution
/// The problem is that ast::ptr< ... > uses increment/decrement which won't work well with
/// forward declarations
inline void increment( const class Type * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class Type * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class VoidType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class VoidType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class BasicType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class BasicType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class PointerType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class PointerType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class ArrayType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class ArrayType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class ReferenceType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class ReferenceType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class QualifiedType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class QualifiedType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class FunctionType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class FunctionType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class ReferenceToType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class ReferenceToType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class StructInstType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class StructInstType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class UnionInstType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class UnionInstType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class EnumInstType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class EnumInstType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class TraitInstType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class TraitInstType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class TypeInstType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class TypeInstType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class TupleType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class TupleType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class TypeofType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class TypeofType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class AttrType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class AttrType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class VarArgsType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class VarArgsType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class ZeroType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class ZeroType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class OneType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class OneType * node, Node::ref_type ref ) { node->decrement( ref ); }
inline void increment( const class GlobalScopeType * node, Node::ref_type ref ) { node->increment( ref ); }
inline void decrement( const class GlobalScopeType * node, Node::ref_type ref ) { node->decrement( ref ); }

}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
