//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ForallSubstitutionTable.hpp --
//
// Author           : Aaron B. Moss
// Created On       : Thu Jun 27 14:00:00 2019
// Last Modified By : Aaron B. Moss
// Last Modified On : Thu Jun 27 14:00:00 2019
// Update Count     : 1
//

#pragma once

#include <vector>

#include "Node.hpp"  // for ptr
#include "Common/ScopedMap.h"

namespace ast {

class TypeDecl;
class Visitor;

/// Wrapper for TypeDecl substitution table
class ForallSubstitutionTable {
	ScopedMap< const TypeDecl *, const TypeDecl * > decls;

public:
	/// Replaces given declaration with value in the table, if present, otherwise returns argument
	const TypeDecl * replace( const TypeDecl * d ) {
		auto it = decls.find( d );
		if ( it != decls.end() ) return it->second;
		return d;
	}

	/// Builds a new forall list mutated according to the given visitor
	std::vector< ptr< TypeDecl > > clone( 
		const std::vector< ptr< TypeDecl > > & forall, Visitor & v );

	/// Introduces a new lexical scope
	void beginScope() { decls.beginScope(); }

	/// Concludes a lexical scope
	void endScope() { decls.endScope(); }
};

}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //