//                              -*- Mode: CFA -*-
//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// threads.c --
//
// Author           : Thierry Delisle
// Created On       : Tue Jan 17 12:27:26 2016
// Last Modified By : Thierry Delisle
// Last Modified On : --
// Update Count     : 0
//

#include "threads"

#include "kernel"
#include "libhdr.h"

#define __CFA_INVOKE_PRIVATE__
#include "invoke.h"

#include <stdlib>

//-----------------------------------------------------------------------------
// Forward declarations
forall(otype T | is_thread(T) )
void start( thread(T)* this );

forall(otype T | is_thread(T) )
void stop( thread(T)* this );

//-----------------------------------------------------------------------------
// Thread ctors and dtors

void ?{}(thread_h* this) {
	(&this->c){};
}

void ^?{}(thread_h* this) {
	^(&this->c){};
}

forall(otype T | is_thread(T) )
void ?{}( thread(T)* this ) {
	printf("thread() ctor\n");
	(&this->handle){};
	start(this);
}

forall(otype T, ttype P | is_thread(T) | { void ?{}(T*, P); } )
void ?{}( thread(T)* this, P params ) {
	(&this->handle){ params };
	start(this);
}

forall(otype T | is_thread(T) )
void ^?{}( thread(T)* this ) {
	stop(this);
	^(&this->handle){};
}

//-----------------------------------------------------------------------------
// Starting and stopping threads
extern "C" {
      forall(dtype T | is_thread(T))
      void CtxInvokeThread(T * this);
}

forall(otype T | is_thread(T))
void start( thread(T)* this ) {
	T* handle  = &this->handle;
	coroutine* thrd_c = get_coroutine(handle);
	thread_h*  thrd_h = get_thread   (handle);
	thrd_c->last = this_coroutine();
	current_coroutine = thrd_c;

	// LIB_DEBUG_PRINTF("Thread start : %p (t %p, c %p)\n", handle, thrd_c, thrd_h);

	create_stack(&thrd_c->stack, thrd_c->stack.size);
	CtxStart(handle, CtxInvokeThread);
	CtxSwitch( thrd_c->last->stack.context, thrd_c->stack.context );

	scheduler_add(thrd_h);
}

forall(otype T | is_thread(T) )
void stop( thread(T)* this ) {

}

// Local Variables: //
// mode: c //
// tab-width: 4 //
// End: //
