/*
 * This file is part of the Cforall project
 *
 * $Id: PolyMutator.h,v 1.8 2005/08/29 20:14:13 rcbilson Exp $
 *
 */

#ifndef REMOVE_INIT_H
#define REMOVE_INIT_H

#include <string>
#include <list>

#include "SynTree/SynTree.h"
#include "SynTree/Declaration.h"
#include "SynTree/Mutator.h"

namespace InitTweak {

void tweak( std::list< Declaration * > translationUnit );

class RemoveInit : public Mutator {
public:
  // RemoveInit();
  virtual ObjectDecl *mutate(ObjectDecl *objDecl);
  virtual CompoundStmt *mutate(CompoundStmt *compoundStmt);
protected:
  std::list< Statement* > stmtsToAddAfter;
  void mutateStatementList( std::list< Statement* > &statements );
};

} // namespace 

#endif /* #ifndef GENPOLY_POLYMUTATOR_H */
