//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// vector_int.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Wed May 27 17:56:53 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed May 27 18:39:05 2015
// Update Count     : 2
//

#ifndef VECTOR_INT_H
#define VECTOR_INT_H

// A flexible array, similar to a C++ vector, that holds integers and can be resized dynamically

typedef struct vector_int {
	int last;											// last used index
	int capacity;										// last possible index before reallocation
	int *data;											// array
} vector_int;

vector_int vector_int_allocate();						// allocate vector with default capacity
vector_int vector_int_allocate( int reserve );			// allocate vector with specified capacity
void vector_int_deallocate( vector_int );				// deallocate vector's storage

void reserve( vector_int *vec, int reserve );			// reserve more capacity
void append( vector_int *vec, int element );			// add element to end of vector, resizing as necessary

// implement bounded_array

lvalue int ?[?]( vector_int vec, int index );			// access to arbitrary element (does not resize)
int last( vector_int vec );								// return last element

#endif // VECTOR_INT_H

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa vector_int.c" //
// End: //
