//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// LabelFixer.h -- 
//
// Author           : Rodolfo G. Esteves
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Fri May 29 15:25:55 2015
// Update Count     : 11
//

#ifndef LABEL_FIXER_H
#define LABEL_FIXER_H

#include "utility.h"
#include "SynTree/SynTree.h"
#include "SynTree/Visitor.h"
#include "LabelGenerator.h"

#include <map>

namespace ControlStruct {
	class LabelFixer : public Visitor {
		typedef Visitor Parent;
	  public:
		LabelFixer( LabelGenerator *gen = 0 );

		std::map < Label, Statement * > *resolveJumps() throw ( SemanticError );

		// Declarations
		virtual void visit( FunctionDecl *functionDecl );

		// Statements
		void visit( Statement *stmt );

		virtual void visit( CompoundStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( NullStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( ExprStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( IfStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( WhileStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( ForStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( SwitchStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( ChooseStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( FallthruStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( CaseStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( ReturnStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( TryStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( CatchStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( DeclStmt *stmt ) { visit( (Statement *)stmt ); return Parent::visit( stmt ); }
		virtual void visit( BranchStmt *branchStmt );

		Label setLabelsDef( std::list< Label > &, Statement *definition );
		void setLabelsUsg( Label, BranchStmt *usage = 0 );

	  private:
		class Entry {
		  public:
			Entry( Statement *to = 0, BranchStmt *from = 0 );
			bool used() { return ( usage.empty() ); }
			bool defined() { return ( definition != 0 ); }
			bool insideLoop();

			Label get_label() const { return label; }
			void set_label( Label lab ) { label = lab; }

			Statement *get_definition() const { return definition; }
			void set_definition( Statement *def ) { definition = def; }

			std::list< BranchStmt *> &get_uses() { return usage; }
			void add_use ( BranchStmt *use ) { usage.push_back( use ); }
			void add_uses ( std::list<BranchStmt *> uses ) { usage.insert( usage.end(), uses.begin(), uses.end() ); }
		  private:
			Label label;  
			Statement *definition;
			std::list<BranchStmt *> usage;
		};
	          
		std::map < Label, Entry *> labelTable;
		LabelGenerator *generator;
	};
} // namespace ControlStruct

#endif // LABEL_FIXER_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
