//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// FixFunction.h -- 
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 17:02:08 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun May 17 17:03:43 2015
// Update Count     : 2
//

#ifndef FIXFUNCTION_H
#define FIXFUNCTION_H

#include "SynTree/Mutator.h"

namespace SymTab {
	/// Replaces function and array types by equivalent pointer types.
	class FixFunction : public Mutator {
		typedef Mutator Parent;
	  public:
		FixFunction();

		bool get_isVoid() const { return isVoid; }
		void set_isVoid( bool newValue ) { isVoid = newValue; }
	  private:
		virtual DeclarationWithType* mutate(FunctionDecl *functionDecl);

		virtual Type* mutate(VoidType *voidType);
		virtual Type* mutate(BasicType *basicType);
		virtual Type* mutate(PointerType *pointerType);
		virtual Type* mutate(ArrayType *arrayType);
		virtual Type* mutate(StructInstType *aggregateUseType);
		virtual Type* mutate(UnionInstType *aggregateUseType);
		virtual Type* mutate(EnumInstType *aggregateUseType);
		virtual Type* mutate(ContextInstType *aggregateUseType);
		virtual Type* mutate(TypeInstType *aggregateUseType);
		virtual Type* mutate(TupleType *tupleType);
  
		bool isVoid;
	};
} // namespace SymTab

#endif // FIXFUNCTION_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
