//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Alternative.h --
//
// Author           : Richard C. Bilson
// Created On       : Sat May 16 23:45:43 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 09:36:36 2017
// Update Count     : 3
//

#pragma once

#include <iosfwd>             // for ostream
#include <vector>             // for vector

#include "Cost.h"             // for Cost
#include "TypeEnvironment.h"  // for TypeEnvironment

class Expression;

namespace ResolvExpr {
	struct Alternative {
		Alternative();
		Alternative( Expression *expr, const TypeEnvironment &env, const Cost &cost );
		Alternative( Expression *expr, const TypeEnvironment &env, const Cost &cost, const Cost &cvtCost );
		Alternative( const Alternative &other );
		Alternative &operator=( const Alternative &other );
		Alternative( Alternative && other );
		Alternative &operator=( Alternative && other );
		~Alternative();

		void print( std::ostream &os, Indenter indent = {} ) const;

		Cost cost;
		Cost cvtCost;
		Expression *expr;
		TypeEnvironment env;
	};

	typedef std::vector< Alternative > AltList;

	/// Moves all elements from src to the end of dst
	void splice( AltList& dst, AltList& src );

	/// Moves all elements from src to the beginning of dst
	void spliceBegin( AltList& dst, AltList& src );
} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
