//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// XXX.cc -- 
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Jun  5 07:46:03 2015
// Update Count     : 2
//

#include "Statement.h"
#include "utility.h"
#include <algorithm>
#include <functional>

using std::string;
using std::endl;

CompoundStmt::CompoundStmt( std::list<Label> labels ) : Statement( labels ) {
}

CompoundStmt::CompoundStmt( const CompoundStmt &other ) : Statement( other ) {
	cloneAll( other.kids, kids );
}

CompoundStmt::~CompoundStmt() {
	deleteAll( kids );
}

void CompoundStmt::print( std::ostream &os, int indent ) {
	os << string( indent, ' ' ) << "CompoundStmt" << endl ;
	printAll( kids, os, indent + 2 );
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
