#include "SynTree.h"
#include "Visitor.h"
#include "Type.h"
#include "Declaration.h"
#include "utility.h"

const char *BasicType::typeNames[BasicType::NUMBER_OF_BASIC_TYPES] = {
    "_Bool",
    "char",
    "char",
    "unsigned char",
    "short",
    "short unsigned",
    "int",
    "unsigned int",
    "long int",
    "long unsigned int",
    "long long int",
    "long long unsigned int",
    "float",
    "double",
    "long double",
    "float _Complex",
    "double _Complex",
    "long double _Complex",
    "float _Imaginary",
    "double _Imaginary",
    "long double _Imaginary",
};

Type::Type( const Qualifiers &tq ) : tq( tq ) {}

Type::Type( const Type &other ) : tq( other.tq ) {
    cloneAll( other.forall, forall );
}

Type::~Type() {
    deleteAll( forall );
}

void Type::print( std::ostream &os, int indent ) const {
    if ( !forall.empty() ) {
	os << "forall" << std::endl;
	printAll( forall, os, indent + 4 );
	os << std::string( indent+2, ' ' );
    } // if
    if ( tq.isConst ) {
	os << "const ";
    } // if
    if ( tq.isVolatile ) {
	os << "volatile ";
    } // if
    if ( tq.isRestrict ) {
	os << "restrict ";
    } // if
    if ( tq.isLvalue ) {
	os << "lvalue ";
    } // if
    if ( tq.isAtomic ) {
	os << "_Atomic ";
    } // if
}
