#include <stdio.h>
#include <ctype.h>
struct mf_ret {
  int freq;
  char ch;
};

struct mf_ret most_frequent(const char * str) {
  char freqs [26] = { 0 };
  struct mf_ret ret = { 0, 'a' };
  for (int i = 0; str[i] != '\0'; ++i) {
    if (isalpha(str[i])) {        // only count letters
      int ch = tolower(str[i]);   // convert to lower case
      int idx = ch-'a';
      if (++freqs[idx] > ret.freq) {  // update on new max
        ret.freq = freqs[idx];
        ret.ch = ch;
      }
    }
  }
  return ret;
}

void dothing(const char * str) {
  struct mf_ret ret = most_frequent(str);
  printf("%s -- %d %c\n", str, ret.freq, ret.ch);
}

int main() {
  dothing("hello");
  dothing("hello, world!");
  dothing("aaabbbba");
  dothing("");
}
