//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// algorithm.c --
//
// Author           : Peter A. Buhr
// Created On       : Thu Jan 28 17:10:29 2016
// Last Modified By : Rob Schluntz
// Last Modified On : Thu Feb 04 17:19:12 2016
// Update Count     : 54
//

#include "algorithm"

forall( type T | { int ?<?( const T, const T ); } )
T min( const T t1, const T t2 ) {
	return t1 < t2 ? t1 : t2;
} // min

forall( type T | { int ?>?( const T, const T ); } )
T max( const T t1, const T t2 ) {
	return t1 > t2 ? t1 : t2;
} // max

//---------------------------------------

forall( type T )
void swap( T * t1, T * t2 ) {
	T temp = *t1;
	*t1 = *t2;
	*t2 = temp;
} // swap

//---------------------------------------

extern "C" {
#define _XOPEN_SOURCE									// required to access "rand48" routines
#include <stdlib.h>										// abs, labs, llabs
#include <math.h>										// fabsf, fabs, fabsl
#include <complex.h>									// cabsf, cabs, cabsl
#undef I												// free name
} // extern

char abs( char v ) { return abs( (int)v ); }
long int abs( long int v ) { return labs( v ); }
long long int abs( long long int v ) { return llabs( v ); }
float abs( float v ) { return fabsf( v ); }
double abs( double v ) { return fabs( v ); }
long double abs( long double v ) { return fabsl( v ); }
float _Complex abs( float _Complex v ) { return cabsf( v ); }
double _Complex abs( double _Complex v ) { return cabs( v ); }
long double _Complex abs( long double _Complex v ) { return cabsl( v ); }

//---------------------------------------

void randseed( long int s ) { srand48( s ); }
char random() { return lrand48(); }
int random() { return mrand48(); }
unsigned int random() { return lrand48(); }
long int random() { return mrand48(); }
unsigned long int random() { return lrand48(); }
float random() { return (float)drand48(); }				// otherwise float uses lrand48
double random() { return drand48(); }
float _Complex random() { return (float)drand48() + (float _Complex)(drand48() * _Complex_I); }
double _Complex random() { return drand48() + (double _Complex)(drand48() * _Complex_I); }
long double _Complex random() { return (long double)drand48() + (long double _Complex)(drand48() * _Complex_I); }

// Local Variables: //
// tab-width: 4 //
// End: //
