#!/usr/bin/env bash

# A utility for manual ...
# (a) validation: helping you agree that what's in .expect is right
# (b) failure replay: helping you debug one subcase, without using parent--child processes

# Usage:
# mkdir ~/uchunk-temp
# cd ~/uchunk-temp
# rm *
# ~/mywork/cfa-cc/tests/io/manipulatorsInput-uchunk.extra.sh
# ls
# diff -y all-noend.expect.txt all-noend.cpp-actual.txt | nl
# ./uchunk-getline-cfa < ~/mywork/cfa-cc/tests/io/.in/manipulatorsInput-uchunk.getline.1.txt

SCRIPT_DIR=$( cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )
cfa=${cfa:-cfa}
CXX=${CXX:-g++}

set -v
$CXX -x c++ $SCRIPT_DIR/manipulatorsInput-uchunk.cfa -DIN_DIR=$SCRIPT_DIR/.in/ -o uchunk-all-cpp
$cfa        $SCRIPT_DIR/manipulatorsInput-uchunk.cfa -DIN_DIR=$SCRIPT_DIR/.in/ -o uchunk-all-cfa

$CXX -x c++ $SCRIPT_DIR/manipulatorsInput-uchunk.cfa -DSUBCASE_ISOLATION=default -o uchunk-default-cpp
$cfa        $SCRIPT_DIR/manipulatorsInput-uchunk.cfa -DSUBCASE_ISOLATION=default -o uchunk-default-cfa
$CXX -x c++ $SCRIPT_DIR/manipulatorsInput-uchunk.cfa -DSUBCASE_ISOLATION=getline -o uchunk-getline-cpp
$cfa        $SCRIPT_DIR/manipulatorsInput-uchunk.cfa -DSUBCASE_ISOLATION=getline -o uchunk-getline-cfa


cp $SCRIPT_DIR/.expect/manipulatorsInput-uchunk.txt all.expect.txt
./uchunk-all-cpp > all.cpp-actual.txt
./uchunk-all-cfa > all.cfa-actual.txt

sed 's/^END.*/END -/g' < all.expect.txt      > all-noend.expect.txt
sed 's/^END.*/END -/g' < all.cpp-actual.txt  > all-noend.cpp-actual.txt
sed 's/^END.*/END -/g' < all.cfa-actual.txt  > all-noend.cfa-actual.txt

ls -v $SCRIPT_DIR/.in/manipulatorsInput-uchunk* | xargs -n 1 -I {} bash -c 'echo {}; printf \"; cat {}; echo \"' > all.in.txt

diff -q all-noend.expect.txt all-noend.cpp-actual.txt
diff -q all.expect.txt all.cfa-actual.txt
diff -q all.cpp-actual.txt all.cfa-actual.txt  # noisy: shows getline's cfa--cpp END semantic difference
diff -q all-noend.cpp-actual.txt all-noend.cfa-actual.txt

ls

set +v

echo Done.  Further useful commands might include:
echo cat all.in.txt
echo diff -y all-noend.expect.txt all-noend.cpp-actual.txt '|' nl
echo diff -y all.expect.txt all.cfa-actual.txt '|' nl
echo diff -y all.cpp-actual.txt all.cfa-actual.txt '|' nl
echo diff -y all-noend.cpp-actual.txt all-noend.cfa-actual.txt '|' nl
echo './uchunk-getline-cfa <' $SCRIPT_DIR/.in/manipulatorsInput-uchunk.getline.1.txt
echo './uchunk-default-cfa <' $SCRIPT_DIR/.in/manipulatorsInput-uchunk.default.1.txt
