//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ApplicationExpr.cc.cc --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Rob Schluntz
// Last Modified On : Tue Apr 26 12:41:06 2016
// Update Count     : 4
//

#include <cassert>               // for strict_dynamic_cast, assert
#include <list>                  // for list
#include <map>                   // for _Rb_tree_const_iterator, map, map<>:...
#include <memory>                // for unique_ptr
#include <ostream>               // for operator<<, ostream, basic_ostream
#include <string>                // for operator<<, string, char_traits
#include <utility>               // for pair

#include "Common/utility.h"      // for maybeClone, cloneAll, deleteAll, pri...
#include "Declaration.h"         // for Declaration
#include "Expression.h"          // for ParamEntry, ApplicationExpr, Expression
#include "ResolvExpr/typeops.h"  // for extractResultType
#include "Type.h"                // for Type, PointerType, FunctionType

ParamEntry::ParamEntry( const ParamEntry &other ) :
		decl( other.decl ), actualType( maybeClone( other.actualType ) ), formalType( maybeClone( other.formalType ) ), expr( maybeClone( other.expr ) ), inferParams( new InferredParams( *other.inferParams ) ) {
}

ParamEntry &ParamEntry::operator=( const ParamEntry &other ) {
	if ( &other == this ) return *this;
	decl = other.decl;
	// xxx - this looks like a memory leak
	actualType = maybeClone( other.actualType );
	formalType = maybeClone( other.formalType );
	expr = maybeClone( other.expr );
	*inferParams = *other.inferParams;
	return *this;
}

ParamEntry::~ParamEntry() {
	delete actualType;
	delete formalType;
	delete expr;
}

ApplicationExpr::ApplicationExpr( Expression *funcExpr, const std::list<Expression *> & args ) : function( funcExpr ), args( args ) {
	PointerType *pointer = strict_dynamic_cast< PointerType* >( funcExpr->get_result() );
	FunctionType *function = strict_dynamic_cast< FunctionType* >( pointer->get_base() );

	set_result( ResolvExpr::extractResultType( function ) );

	assert( result );
}

ApplicationExpr::ApplicationExpr( const ApplicationExpr &other ) :
		Expression( other ), function( maybeClone( other.function ) ) {
	cloneAll( other.args, args );
}

ApplicationExpr::~ApplicationExpr() {
	delete function;
	deleteAll( args );
}

void ApplicationExpr::print( std::ostream &os, Indenter indent ) const {
	os << "Application of" << std::endl << indent+1;
	function->print( os, indent+1 );
	os << std::endl;
	if ( ! args.empty() ) {
		os << indent << "... to arguments" << std::endl;
		printAll( args, os, indent+1 );
	} // if
	Expression::print( os, indent );
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
