//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// ResolveTypeof.cc --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 12:12:20 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue May 19 16:49:04 2015
// Update Count     : 3
//

#include "ResolveTypeof.h"

#include <cassert>               // for assert

#include "Common/PassVisitor.h"  // for PassVisitor
#include "Resolver.h"            // for resolveInVoidContext
#include "SynTree/Expression.h"  // for Expression
#include "SynTree/Mutator.h"     // for Mutator
#include "SynTree/Type.h"        // for TypeofType, Type

namespace SymTab {
class Indexer;
}  // namespace SymTab

namespace ResolvExpr {
	namespace {
#if 0
		void
		printAlts( const AltList &list, std::ostream &os, int indent = 0 )
		{
			for ( AltList::const_iterator i = list.begin(); i != list.end(); ++i ) {
				i->print( os, indent );
				os << std::endl;
			}
		}
#endif
	}

	class ResolveTypeof : public WithShortCircuiting {
	  public:
		ResolveTypeof( const SymTab::Indexer &indexer ) : indexer( indexer ) {}
		void premutate( TypeofType *typeofType );
		Type * postmutate( TypeofType *typeofType );

	  private:
		const SymTab::Indexer &indexer;
	};

	Type * resolveTypeof( Type *type, const SymTab::Indexer &indexer ) {
		PassVisitor<ResolveTypeof> mutator( indexer );
		return type->acceptMutator( mutator );
	}

	void ResolveTypeof::premutate( TypeofType * ) {
		visit_children = false;
	}

	Type * ResolveTypeof::postmutate( TypeofType *typeofType ) {
#if 0
		std::cerr << "resolving typeof: ";
		typeofType->print( std::cerr );
		std::cerr << std::endl;
#endif
		if ( typeofType->expr ) {
			Expression * newExpr = resolveInVoidContext( typeofType->expr, indexer );
			assert( newExpr->result && ! newExpr->result->isVoid() );
			Type * newType = newExpr->result;
			newExpr->result = nullptr;
			delete typeofType;
			delete newExpr;
			return newType;
		} // if
		return typeofType;
	}
} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
