//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// AdjustExprType.cc --
//
// Author           : Richard C. Bilson
// Created On       : Sat May 16 23:41:42 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Mar  2 17:34:53 2016
// Update Count     : 4
//

#include "Common/PassVisitor.h"
#include "SymTab/Indexer.h"       // for Indexer
#include "SynTree/Declaration.h"  // for TypeDecl, TypeDecl::Kind::Ftype
#include "SynTree/Mutator.h"      // for Mutator
#include "SynTree/Type.h"         // for PointerType, TypeInstType, Type
#include "TypeEnvironment.h"      // for EqvClass, TypeEnvironment

namespace ResolvExpr {
	class AdjustExprType : public WithShortCircuiting {
	  public:
		AdjustExprType( const TypeEnvironment &env, const SymTab::Indexer &indexer );
		void premutate( VoidType * ) { visit_children = false; }
		void premutate( BasicType * ) { visit_children = false; }
		void premutate( PointerType * ) { visit_children = false; }
		void premutate( ArrayType * ) { visit_children = false; }
		void premutate( FunctionType * ) { visit_children = false; }
		void premutate( StructInstType * ) { visit_children = false; }
		void premutate( UnionInstType * ) { visit_children = false; }
		void premutate( EnumInstType * ) { visit_children = false; }
		void premutate( TraitInstType * ) { visit_children = false; }
		void premutate( TypeInstType * ) { visit_children = false; }
		void premutate( TupleType * ) { visit_children = false; }
		void premutate( VarArgsType * ) { visit_children = false; }
		void premutate( ZeroType * ) { visit_children = false; }
		void premutate( OneType * ) { visit_children = false; }

		Type * postmutate( ArrayType *arrayType );
		Type * postmutate( FunctionType *functionType );
		Type * postmutate( TypeInstType *aggregateUseType );

	  private:
		const TypeEnvironment &env;
		const SymTab::Indexer &indexer;
	};

	void adjustExprType( Type *&type, const TypeEnvironment &env, const SymTab::Indexer &indexer ) {
		PassVisitor<AdjustExprType> adjuster( env, indexer );
		Type *newType = type->acceptMutator( adjuster );
		type = newType;
	}

	AdjustExprType::AdjustExprType( const TypeEnvironment &env, const SymTab::Indexer &indexer )
		: env( env ), indexer( indexer ) {
	}

	Type * AdjustExprType::postmutate( ArrayType * arrayType ) {
		PointerType *pointerType = new PointerType( arrayType->get_qualifiers(), arrayType->base );
		arrayType->base = nullptr;
		delete arrayType;
		return pointerType;
	}

	Type * AdjustExprType::postmutate( FunctionType * functionType ) {
		return new PointerType( Type::Qualifiers(), functionType );
	}

	Type * AdjustExprType::postmutate( TypeInstType * typeInst ) {
		EqvClass eqvClass;
		if ( env.lookup( typeInst->get_name(), eqvClass ) ) {
			if ( eqvClass.data.kind == TypeDecl::Ftype ) {
				PointerType *pointerType = new PointerType( Type::Qualifiers(), typeInst );
				return pointerType;
			}
		} else if ( NamedTypeDecl *ntDecl = indexer.lookupType( typeInst->get_name() ) ) {
			if ( TypeDecl *tyDecl = dynamic_cast< TypeDecl* >( ntDecl ) ) {
				if ( tyDecl->get_kind() == TypeDecl::Ftype ) {
					PointerType *pointerType = new PointerType( Type::Qualifiers(), typeInst );
					return pointerType;
				} // if
			} // if
		} // if
		return typeInst;
	}
} // namespace ResolvExpr

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
