//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// rational.c -- test rational number package
//
// Author           : Peter A. Buhr
// Created On       : Mon Mar 28 08:43:12 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Oct 10 23:25:04 2017
// Update Count     : 67
//

#include <rational>
#include <limits>
#include <stdlib>
#include <fstream>

// UNNECESSARY, FIX ME
void ?{}( int & this ) { this = 0; }
void ?{}( int & this, zero_t ) { this = 0; }
void ?{}( int & this, one_t ) { this = 1; }
double convert( int i ) { return (double)i; }
int convert( double d ) { return (int)d; }

int main() {
	sout | "constructor" | endl;
	Rational(int) a = { 3 }, b = { 4 }, c;
	sout | a | b | c | endl;

	a = (Rational(int)){ 4, 8 };
	b = (Rational(int)){ 5, 7 };
	sout | a | b | endl;
	a = (Rational(int)){ -2, -3 };
	b = (Rational(int)){ 3, -2 };
	sout | a | b | endl;
	a = (Rational(int)){ -2, 3 };
	b = (Rational(int)){ 3, 2 };
	sout | a | b | endl;

	sout | "logical" | endl;
	a = (Rational(int)){ -2 };
	b = (Rational(int)){ -3, 2 };
	sout | a | b | endl;
//	sout | a == 1 | endl; // FIX ME
	sout | a != b | endl;
	sout | a <  b | endl;
	sout | a <= b | endl;
	sout | a >  b | endl;
	sout | a >= b | endl;

	sout | "arithmetic" | endl;
	sout | a | b | endl;
	sout | a + b | endl;
	sout | a - b | endl;
	sout | a * b | endl;
	sout | a / b | endl;

	sout | "conversion" | endl;
	a = (Rational(int)){ 3, 4 };
	sout | widen( a ) | endl;
	a = (Rational(int)){ 1, 7 };
	sout | widen( a ) | endl;
	a = (Rational(int)){ 355, 113 };
	sout | widen( a ) | endl;
	sout | narrow( 0.75, 4 ) | endl;
	sout | narrow( 0.14285714285714, 16 ) | endl;
	sout | narrow( 3.14159265358979, 256 ) | endl;

	sout | "decompose" | endl;
	int n, d;
//	[n, d] = a;
//	sout | a | n | d | endl;

	sout | "more tests" | endl;
	Rational(int) x = { 1, 2 }, y = { 2 };
	sout | x - y | endl;
	sout | x > y | endl;
	sout | x | numerator( x, 2 ) | x | endl;
	sout | y | denominator( y, -2 ) | y | endl;

	Rational(int) z = { 0, 5 };
	sout | z | endl;

	sout | x | numerator( x, 0 ) | x | endl;

	x = (Rational(int)){ 1, MAX } + (Rational(int)){ 1, MAX };
	sout | x | endl;
	x = (Rational(int)){ 3, MAX } + (Rational(int)){ 2, MAX };
	sout | x | endl;

	sin | a | b;
	sout | a | b | endl;
} // main

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa rational.c" //
// End: //
