//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Visitor.hpp -- Interface of a class that visits ast nodes.
//
// Author           : Andrew Beach
// Created On       : Thr May 9 15:28:00 2019
// Last Modified By : Andrew Beach
// Last Modified On : Thr May 9 15:33:00 2019
// Update Count     : 0
//

#pragma once

#include "Fwd.hpp"

namespace ast {

class Visitor {
public:
    virtual DeclWithType *     visit( const ObjectDecl           * ) = 0;
    virtual DeclWithType *     visit( const FunctionDecl         * ) = 0;
    virtual Decl *             visit( const StructDecl           * ) = 0;
    virtual Decl *             visit( const UnionDecl            * ) = 0;
    virtual Decl *             visit( const EnumDecl             * ) = 0;
    virtual Decl *             visit( const TraitDecl            * ) = 0;
    virtual Decl *             visit( const TypeDecl             * ) = 0;
    virtual Decl *             visit( const TypedefDecl          * ) = 0;
    virtual AsmDecl *          visit( const AsmDecl              * ) = 0;
    virtual StaticAssertDecl * visit( const StaticAssertDecl     * ) = 0;
    virtual CompoundStmt *     visit( const CompoundStmt         * ) = 0;
    virtual Stmt *             visit( const ExprStmt             * ) = 0;
    virtual Stmt *             visit( const AsmStmt              * ) = 0;
    virtual Stmt *             visit( const DirectiveStmt        * ) = 0;
    virtual Stmt *             visit( const IfStmt               * ) = 0;
    virtual Stmt *             visit( const WhileStmt            * ) = 0;
    virtual Stmt *             visit( const ForStmt              * ) = 0;
    virtual Stmt *             visit( const SwitchStmt           * ) = 0;
    virtual Stmt *             visit( const CaseStmt             * ) = 0;
    virtual Stmt *             visit( const BranchStmt           * ) = 0;
    virtual Stmt *             visit( const ReturnStmt           * ) = 0;
    virtual Stmt *             visit( const ThrowStmt            * ) = 0;
    virtual Stmt *             visit( const TryStmt              * ) = 0;
    virtual Stmt *             visit( const CatchStmt            * ) = 0;
    virtual Stmt *             visit( const FinallyStmt          * ) = 0;
    virtual Stmt *             visit( const WaitForStmt          * ) = 0;
    virtual Stmt *             visit( const WithStmt             * ) = 0;
    virtual NullStmt *         visit( const NullStmt             * ) = 0;
    virtual Stmt *             visit( const DeclStmt             * ) = 0;
    virtual Stmt *             visit( const ImplicitCtorDtorStmt * ) = 0;
    virtual Expr *             visit( const ApplicationExpr      * ) = 0;
    virtual Expr *             visit( const UntypedExpr          * ) = 0;
    virtual Expr *             visit( const NameExpr             * ) = 0;
    virtual Expr *             visit( const AddressExpr          * ) = 0;
    virtual Expr *             visit( const LabelAddressExpr     * ) = 0;
    virtual Expr *             visit( const CastExpr             * ) = 0;
    virtual Expr *             visit( const KeywordCastExpr      * ) = 0;
    virtual Expr *             visit( const VirtualCastExpr      * ) = 0;
    virtual Expr *             visit( const UntypedMemberExpr    * ) = 0;
    virtual Expr *             visit( const MemberExpr           * ) = 0;
    virtual Expr *             visit( const VariableExpr         * ) = 0;
    virtual Expr *             visit( const ConstantExpr         * ) = 0;
    virtual Expr *             visit( const SizeofExpr           * ) = 0;
    virtual Expr *             visit( const AlignofExpr          * ) = 0;
    virtual Expr *             visit( const UntypedOffsetofExpr  * ) = 0;
    virtual Expr *             visit( const OffsetofExpr         * ) = 0;
    virtual Expr *             visit( const OffsetPackExpr       * ) = 0;
    virtual Expr *             visit( const AttrExpr             * ) = 0;
    virtual Expr *             visit( const LogicalExpr          * ) = 0;
    virtual Expr *             visit( const ConditionalExpr      * ) = 0;
    virtual Expr *             visit( const CommaExpr            * ) = 0;
    virtual Expr *             visit( const TypeExpr             * ) = 0;
    virtual Expr *             visit( const AsmExpr              * ) = 0;
    virtual Expr *             visit( const ImplicitCopyCtorExpr * ) = 0;
    virtual Expr *             visit( const ConstructorExpr      * ) = 0;
    virtual Expr *             visit( const CompoundLiteralExpr  * ) = 0;
    virtual Expr *             visit( const RangeExpr            * ) = 0;
    virtual Expr *             visit( const UntypedTupleExpr     * ) = 0;
    virtual Expr *             visit( const TupleExpr            * ) = 0;
    virtual Expr *             visit( const TupleIndexExpr       * ) = 0;
    virtual Expr *             visit( const TupleAssignExpr      * ) = 0;
    virtual Expr *             visit( const StmtExpr             * ) = 0;
    virtual Expr *             visit( const UniqueExpr           * ) = 0;
    virtual Expr *             visit( const UntypedInitExpr      * ) = 0;
    virtual Expr *             visit( const InitExpr             * ) = 0;
    virtual Expr *             visit( const DeletedExpr          * ) = 0;
    virtual Expr *             visit( const DefaultArgExpr       * ) = 0;
    virtual Expr *             visit( const GenericExpr          * ) = 0;
    virtual Type *             visit( const VoidType             * ) = 0;
    virtual Type *             visit( const BasicType            * ) = 0;
    virtual Type *             visit( const PointerType          * ) = 0;
    virtual Type *             visit( const ArrayType            * ) = 0;
    virtual Type *             visit( const ReferenceType        * ) = 0;
    virtual Type *             visit( const QualifiedType        * ) = 0;
    virtual Type *             visit( const FunctionType         * ) = 0;
    virtual Type *             visit( const StructInstType       * ) = 0;
    virtual Type *             visit( const UnionInstType        * ) = 0;
    virtual Type *             visit( const EnumInstType         * ) = 0;
    virtual Type *             visit( const TraitInstType        * ) = 0;
    virtual Type *             visit( const TypeInstType         * ) = 0;
    virtual Type *             visit( const TupleType            * ) = 0;
    virtual Type *             visit( const TypeofType           * ) = 0;
    virtual Type *             visit( const AttrType             * ) = 0;
    virtual Type *             visit( const VarArgsType          * ) = 0;
    virtual Type *             visit( const ZeroType             * ) = 0;
    virtual Type *             visit( const OneType              * ) = 0;
    virtual Type *             visit( const GlobalScopeType      * ) = 0;
    virtual Designation *      visit( const Designation          * ) = 0;
    virtual Init *             visit( const SingleInit           * ) = 0;
    virtual Init *             visit( const ListInit             * ) = 0;
    virtual Init *             visit( const ConstructorInit      * ) = 0;
    virtual Constant *         visit( const Constant             * ) = 0;
    virtual Attribute *        visit( const Attribute            * ) = 0;
    virtual TypeSubstitution * visit( const TypeSubstitution     * ) = 0;
};

}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
