// 
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
// 
// forctrl.c -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Aug  8 18:32:59 2018
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug 16 09:25:47 2018
// Update Count     : 6
// 

#include <fstream.hfa>

struct S { int i, j; };
void ?{}( S & s ) { s.[i, j] = 0; }
void ?{}( S & s, int i ) { s.[i, j] = [i, 0]; }
void ?{}( S & s, int i, int j ) { s.[i, j] = [i, j]; }
void ?{}( S & s, zero_t ) { s.[i, j] = 0; }
void ?{}( S & s, one_t ) { s.[i, j] = 1; }
S ?+?( S t1, S t2 ) { return (S){ t1.i + t2.i, t1.j + t2.j }; }
int ?<?( S t1, S t2 ) { return t1.i < t2.i && t1.j < t2.j; }
S ?=?( S & t1, S t2 ) { t1.i = t2.i; t1.j = t2.j; return t1; }
S ?+=?( S & t1, S t2 ) { t1 = t1 + t2; return t1; }
S ?+=?( S & t1, one_t ) { t1 = t1 + (S){1}; return t1; }
ofstream & ?|?( ofstream & os, S v ) { return os | '(' | v.i | v.j | ')'; }

int main() {
	while () { sout | "empty"; break; }		sout | endl;
	do { sout | "empty"; break; } while ();	sout | endl;
	for () { sout | "empty"; break; }		sout | endl;
	for ( 10 ) { sout | "X"; }				sout | endl;
	for ( 0.5 ~ 5.5 ) { sout | "Y"; }		sout | endl;
	for ( 2 ~= 10 ~ 2 ) { sout | "Z"; }		sout | endl;
	for ( i; 10 ) { sout | i; }				sout | endl;
	for ( j; 10 ) { sout | j; }				sout | endl;
	for ( i; 0.5 ~ 5.5 ) { sout | i; }		sout | endl;
	for ( i; 2 ~= 10 ~ 2 ) { sout | i; }	sout | endl;
	for ( ui; 2u ~= 10u ~ 2u ) { sout | ui; } sout | endl;
	int start = 3, comp = 10, inc = 2;
	for ( i; start ~ comp ~ inc + 1 ) { sout | i; } sout | endl;

	for ( S s = (S){0}; s < (S){10,10}; s += (S){1} ) { sout | s; } sout | endl;
//	for ( s; (S){10,10} ) { sout | s; } sout | endl;
	for ( s; (S){0} ~ (S){10,10} ) { sout | s; } sout | endl;
	for ( s; (S){0} ~ (S){10,10} ~ (S){1} ) { sout | s; } sout | endl;
}

// Local Variables: //
// tab-width: 4 //
// compile-command: "cfa forctrl.c" //
// End: //
