#include <stdlib>
#include "cfa-stack.h"

forall(otype T) struct stack_node {
	T value;
	stack_node(T)* next;
};

forall(otype T) void ?{}(stack(T)* s) {
	?{}( &s->head, 0 );
}

forall(otype T) void ^?{}(stack(T)* s) {
	stack_node(T)* next = s->head;
	while ( next ) {
		stack_node(T)* crnt = next;
		next = crnt->next;
		delete(crnt);
	}
}

forall(otype T) _Bool empty(const stack(T)* s) {
	return s->head == 0;
}

forall(otype T) void push(stack(T)* s, T value) {
	s->head = ((stack_node(T)*)malloc()){ value, s->head };
}

forall(otype T) T pop(stack(T)* s) {
	stack_node(T)* n = s->head;
	s->head = n->next;
	T x = n->value;
	delete(n);
	return x;
}
