#include <stdlib.h>
#include "c-stack.h"

struct stack_node {
	void* value;
	struct stack_node* next;
};

struct stack new_stack() {
	return (struct stack){ NULL };
}

void clear_stack(struct stack* s) {
	struct stack_node* next = s->head;
	while ( next ) {
		struct stack_node* crnt = next;
		next = crnt->next;
		free(crnt->value);
		free(crnt);
	}
}

_Bool stack_empty(const struct stack* s) {
	return s->head == NULL;
}

void push_stack(struct stack* s, void* value) {
	struct stack_node* n = malloc(sizeof(struct stack_node));
	*n = (struct stack_node){ value, s->head };
	s->head = n;
}

void* pop_stack(struct stack* s) {
	struct stack_node* n = s->head;
	s->head = n->next;
	void* x = n->value;
	free(n);
	return x;
}