#include <stdio.h>
#include <time.h>

#define N 200000000

long ms_between(clock_t start, clock_t end) {
	return (end - start) / (CLOCKS_PER_SEC / 1000);
}

#define TIMED(name, code) { \
	clock_t start, end; \
	start = clock(); \
	code \
	end = clock(); \
	printf("%s:\t%7ld ms\n", name, ms_between(start, end)); \
}

#define REPEAT_TIMED(name, code) TIMED( name, for (int i = 0; i < N; ++i) { code } )
