//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Visitor.h --
//
// Author           : Richard C. Bilson
// Created On       : Mon May 18 07:44:20 2015
// Last Modified By : Andrew Beach
// Last Modified On : Mon Jul 24 16:28:00 2017
// Update Count     : 13
//

#pragma once

#include "Common/SemanticError.h"  // for SemanticError
#include "SynTree.h"               // for AST nodes

class Visitor {
  protected:
	Visitor() = default;
	virtual ~Visitor() = default;
  public:
	// visit: Default implementation of all functions visits the children
	// of the given syntax node, but performs no other action.

	virtual void visit( ObjectDecl * objectDecl ) = 0;
	virtual void visit( FunctionDecl * functionDecl ) = 0;
	virtual void visit( StructDecl * aggregateDecl ) = 0;
	virtual void visit( UnionDecl * aggregateDecl ) = 0;
	virtual void visit( EnumDecl * aggregateDecl ) = 0;
	virtual void visit( TraitDecl * aggregateDecl ) = 0;
	virtual void visit( TypeDecl * typeDecl ) = 0;
	virtual void visit( TypedefDecl * typeDecl ) = 0;
	virtual void visit( AsmDecl * asmDecl ) = 0;

	virtual void visit( CompoundStmt * compoundStmt ) = 0;
	virtual void visit( ExprStmt * exprStmt ) = 0;
	virtual void visit( AsmStmt * asmStmt ) = 0;
	virtual void visit( IfStmt * ifStmt ) = 0;
	virtual void visit( WhileStmt * whileStmt ) = 0;
	virtual void visit( ForStmt * forStmt ) = 0;
	virtual void visit( SwitchStmt * switchStmt ) = 0;
	virtual void visit( CaseStmt * caseStmt ) = 0;
	virtual void visit( BranchStmt * branchStmt ) = 0;
	virtual void visit( ReturnStmt * returnStmt ) = 0;
	virtual void visit( ThrowStmt * throwStmt ) = 0;
	virtual void visit( TryStmt * tryStmt ) = 0;
	virtual void visit( CatchStmt * catchStmt ) = 0;
	virtual void visit( FinallyStmt * finallyStmt ) = 0;
	virtual void visit( WaitForStmt * waitforStmt ) = 0;
	virtual void visit( WithStmt * withStmt ) = 0;
	virtual void visit( NullStmt * nullStmt ) = 0;
	virtual void visit( DeclStmt * declStmt ) = 0;
	virtual void visit( ImplicitCtorDtorStmt * impCtorDtorStmt ) = 0;

	virtual void visit( ApplicationExpr * applicationExpr ) = 0;
	virtual void visit( UntypedExpr * untypedExpr ) = 0;
	virtual void visit( NameExpr * nameExpr ) = 0;
	virtual void visit( CastExpr * castExpr ) = 0;
	virtual void visit( VirtualCastExpr * castExpr ) = 0;
	virtual void visit( AddressExpr * addressExpr ) = 0;
	virtual void visit( LabelAddressExpr * labAddressExpr ) = 0;
	virtual void visit( UntypedMemberExpr * memberExpr ) = 0;
	virtual void visit( MemberExpr * memberExpr ) = 0;
	virtual void visit( VariableExpr * variableExpr ) = 0;
	virtual void visit( ConstantExpr * constantExpr ) = 0;
	virtual void visit( SizeofExpr * sizeofExpr ) = 0;
	virtual void visit( AlignofExpr * alignofExpr ) = 0;
	virtual void visit( UntypedOffsetofExpr * offsetofExpr ) = 0;
	virtual void visit( OffsetofExpr * offsetofExpr ) = 0;
	virtual void visit( OffsetPackExpr * offsetPackExpr ) = 0;
	virtual void visit( AttrExpr * attrExpr ) = 0;
	virtual void visit( LogicalExpr * logicalExpr ) = 0;
	virtual void visit( ConditionalExpr * conditionalExpr ) = 0;
	virtual void visit( CommaExpr * commaExpr ) = 0;
	virtual void visit( TypeExpr * typeExpr ) = 0;
	virtual void visit( AsmExpr * asmExpr ) = 0;
	virtual void visit( ImplicitCopyCtorExpr * impCpCtorExpr ) = 0;
	virtual void visit( ConstructorExpr *  ctorExpr ) = 0;
	virtual void visit( CompoundLiteralExpr * compLitExpr ) = 0;
	virtual void visit( RangeExpr * rangeExpr ) = 0;
	virtual void visit( UntypedTupleExpr * tupleExpr ) = 0;
	virtual void visit( TupleExpr * tupleExpr ) = 0;
	virtual void visit( TupleIndexExpr * tupleExpr ) = 0;
	virtual void visit( TupleAssignExpr * assignExpr ) = 0;
	virtual void visit( StmtExpr *  stmtExpr ) = 0;
	virtual void visit( UniqueExpr *  uniqueExpr ) = 0;
	virtual void visit( UntypedInitExpr *  initExpr ) = 0;
	virtual void visit( InitExpr *  initExpr ) = 0;
	virtual void visit( DeletedExpr * delExpr ) = 0;

	virtual void visit( VoidType * basicType ) = 0;
	virtual void visit( BasicType * basicType ) = 0;
	virtual void visit( PointerType * pointerType ) = 0;
	virtual void visit( ArrayType * arrayType ) = 0;
	virtual void visit( ReferenceType * refType ) = 0;
	virtual void visit( FunctionType * functionType ) = 0;
	virtual void visit( StructInstType * aggregateUseType ) = 0;
	virtual void visit( UnionInstType * aggregateUseType ) = 0;
	virtual void visit( EnumInstType * aggregateUseType ) = 0;
	virtual void visit( TraitInstType * aggregateUseType ) = 0;
	virtual void visit( TypeInstType * aggregateUseType ) = 0;
	virtual void visit( TupleType * tupleType ) = 0;
	virtual void visit( TypeofType * typeofType ) = 0;
	virtual void visit( AttrType * attrType ) = 0;
	virtual void visit( VarArgsType * varArgsType ) = 0;
	virtual void visit( ZeroType * zeroType ) = 0;
	virtual void visit( OneType * oneType ) = 0;

	virtual void visit( Designation * designation ) = 0;
	virtual void visit( SingleInit * singleInit ) = 0;
	virtual void visit( ListInit * listInit ) = 0;
	virtual void visit( ConstructorInit * ctorInit ) = 0;

	virtual void visit( Subrange * subrange ) = 0;

	virtual void visit( Constant * constant ) = 0;

	virtual void visit( Attribute * attribute ) = 0;
};

template< typename TreeType, typename VisitorType >
inline void maybeAccept( TreeType *tree, VisitorType &visitor ) {
	if ( tree ) {
		tree->accept( visitor );
	}
}

template< typename Container, typename VisitorType >
inline void acceptAll( Container &container, VisitorType &visitor ) {
	SemanticErrorException errors;
	for ( typename Container::iterator i = container.begin(); i != container.end(); ++i ) {
		try {
			if ( *i ) {
				(*i)->accept( visitor );
			}
		} catch( SemanticErrorException &e ) {
			errors.append( e );
		}
	}
	if ( ! errors.isEmpty() ) {
		throw errors;
	}
}

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
