//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Alternative.h --
//
// Author           : Richard C. Bilson
// Created On       : Sat May 16 23:45:43 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat May 16 23:54:39 2015
// Update Count     : 2
//

#ifndef ALTERNATIVE_H
#define ALTERNATIVE_H

#include <list>
#include "SynTree/SynTree.h"
#include "Cost.h"
#include "TypeEnvironment.h"

namespace ResolvExpr {
	struct Alternative;
	typedef std::list< Alternative > AltList;

	struct Alternative {
		Alternative();
		Alternative( Expression *expr, const TypeEnvironment &env, const Cost &cost );
		Alternative( Expression *expr, const TypeEnvironment &env, const Cost &cost, const Cost &cvtCost );
		Alternative( const Alternative &other );
		Alternative &operator=( const Alternative &other );
		~Alternative();

		void initialize( const Alternative &src, Alternative &dest );

		void print( std::ostream &os, int indent = 0 ) const;

		Cost cost;
		Cost cvtCost;
		Expression *expr;
		TypeEnvironment env;
	};

	/// helper function used by explode
	template< typename OutputIterator >
	void explodeUnique( Expression * expr, const Alternative & alt, OutputIterator out ) {
		Type * res = expr->get_result();
		if ( TupleType * tupleType = dynamic_cast< TupleType * > ( res ) ) {
			if ( TupleExpr * tupleExpr = dynamic_cast< TupleExpr * >( alt.expr ) ) {
				for ( Expression * expr : tupleExpr->get_exprs() ) {
					explodeUnique( expr, alt, out );
				}
			} else {
				UniqueExpr * unq = new UniqueExpr( expr->clone() );
				for ( unsigned int i = 0; i < tupleType->size(); i++ ) {
					TupleIndexExpr * idx = new TupleIndexExpr( unq->clone(), i );
					explodeUnique( idx, alt, out );
					delete idx;
				}
				delete unq;
			}
		} else {
			*out++ = Alternative( expr->clone(), alt.env, alt.cost, alt.cvtCost );
		}
	}

	/// expands a tuple-valued alternative into multiple alternatives, each with a non-tuple-type
	template< typename OutputIterator >
	void explode( Alternative &alt, OutputIterator out ) {
		explodeUnique( alt.expr, alt, out );
	}

	// explode list of alternatives
	template< typename OutputIterator >
	void explode( AltList & alts, OutputIterator out ) {
		for ( Alternative & alt : alts ) {
			explode( alt, out );
		}
	}
} // namespace ResolvExpr

#endif // ALTERNATIVE_H

// Local Variables: //
// tab-width: 4 //
// mode: c++ //
// compile-command: "make install" //
// End: //
