//
// Cforall Version 1.0.0 Copyright (C) 2016 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// algorithm.c --
//
// Author           : Peter A. Buhr
// Created On       : Thu Jan 28 17:10:29 2016
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Aug 23 20:30:44 2017
// Update Count     : 292
//

#include "stdlib"

//---------------------------------------

#define _XOPEN_SOURCE 600								// posix_memalign, *rand48
#include <stdlib.h>										// malloc, free, calloc, realloc, memalign, posix_memalign, bsearch
#include <string.h>										// memcpy, memset
#include <malloc.h>										// malloc_usable_size
#include <math.h>										// fabsf, fabs, fabsl
#include <complex.h>									// _Complex_I

// resize, non-array types
forall( dtype T | sized(T) ) T * alloc( T ptr[], size_t dim, char fill ) {
	size_t olen = malloc_usable_size( ptr );			// current allocation
    char * nptr = (void *)realloc( (void *)ptr, dim * (size_t)sizeof(T) ); // C realloc
	size_t nlen = malloc_usable_size( nptr );			// new allocation
	if ( nlen > olen ) {								// larger ?
		memset( nptr + olen, (int)fill, nlen - olen );	// initialize added storage
	} //
    return (T *)nptr;
} // alloc

// allocation/deallocation and constructor/destructor, non-array types
forall( dtype T | sized(T), ttype Params | { void ?{}( T &, Params ); } )
T * new( Params p ) {
	return &(*malloc()){ p };								// run constructor
} // new

forall( dtype T | sized(T) | { void ^?{}( T & ); } )
void delete( T * ptr ) {
	if ( ptr ) {										// ignore null
		^(*ptr){};											// run destructor
		free( ptr );
	} // if
} // delete

forall( dtype T, ttype Params | sized(T) | { void ^?{}( T & ); void delete( Params ); } )
void delete( T * ptr, Params rest ) {
	if ( ptr ) {										// ignore null
		^(*ptr){};											// run destructor
		free( ptr );
	} // if
	delete( rest );
} // delete


// allocation/deallocation and constructor/destructor, array types
forall( dtype T | sized(T), ttype Params | { void ?{}( T &, Params ); } )
T * anew( size_t dim, Params p ) {
	T *arr = alloc( dim );
	for ( unsigned int i = 0; i < dim; i += 1 ) {
		(arr[i]){ p };									// run constructor
	} // for
	return arr;
} // anew

forall( dtype T | sized(T) | { void ^?{}( T & ); } )
void adelete( size_t dim, T arr[] ) {
	if ( arr ) {										// ignore null
		for ( int i = dim - 1; i >= 0; i -= 1 ) {		// reverse allocation order, must be unsigned
			^(arr[i]){};								// run destructor
		} // for
		free( arr );
	} // if
} // adelete

forall( dtype T | sized(T) | { void ^?{}( T & ); }, ttype Params | { void adelete( Params ); } )
void adelete( size_t dim, T arr[], Params rest ) {
	if ( arr ) {										// ignore null
		for ( int i = dim - 1; i >= 0; i -= 1 ) {		// reverse allocation order, must be unsigned
			^(arr[i]){};								// run destructor
		} // for
		free( arr );
	} // if
	adelete( rest );
} // adelete

//---------------------------------------

int ato( const char * ptr ) {
	int i;
	if ( sscanf( ptr, "%d", &i ) == EOF ) {}
	return i;
} // ato

unsigned int ato( const char * ptr ) {
	unsigned int ui;
	if ( sscanf( ptr, "%u", &ui ) == EOF ) {}
	return ui;
} // ato

long int ato( const char * ptr ) {
	long int li;
	if ( sscanf( ptr, "%ld", &li ) == EOF ) {}
	return li;
} // ato

unsigned long int ato( const char * ptr ) {
	unsigned long int uli;
	if ( sscanf( ptr, "%lu", &uli ) == EOF ) {}
	return uli;
} // ato

long long int ato( const char * ptr ) {
	long long int lli;
	if ( sscanf( ptr, "%lld", &lli ) == EOF ) {}
	return lli;
} // ato

unsigned long long int ato( const char * ptr ) {
	unsigned long long int ulli;
	if ( sscanf( ptr, "%llu", &ulli ) == EOF ) {}
	return ulli;
} // ato


float ato( const char * ptr ) {
	float f;
	if ( sscanf( ptr, "%f", &f ) == EOF ) {}
	return f;
} // ato

double ato( const char * ptr ) {
	double d;
	if ( sscanf( ptr, "%lf", &d ) == EOF ) {}
	return d;
} // ato

long double ato( const char * ptr ) {
	long double ld;
	if ( sscanf( ptr, "%Lf", &ld ) == EOF ) {}
	return ld;
} // ato


float _Complex ato( const char * ptr ) {
	float re, im;
	if ( sscanf( ptr, "%g%gi", &re, &im ) == EOF ) {}
	return re + im * _Complex_I;
} // ato

double _Complex ato( const char * ptr ) {
	double re, im;
	if ( sscanf( ptr, "%lf%lfi", &re, &im ) == EOF ) {}
	return re + im * _Complex_I;
} // ato

long double _Complex ato( const char * ptr ) {
	long double re, im;
	if ( sscanf( ptr, "%Lf%Lfi", &re, &im ) == EOF ) {}
	return re + im * _Complex_I;
} // ato


int strto( const char * sptr, char ** eptr, int base ) {
	return (int)strtol( sptr, eptr, base );
} // strto

unsigned int strto( const char * sptr, char ** eptr, int base ) {
	return (unsigned int)strtoul( sptr, eptr, base );
} // strto

long int strto( const char * sptr, char ** eptr, int base ) {
	return strtol( sptr, eptr, base );
} // strto

unsigned long int strto( const char * sptr, char ** eptr, int base ) {
	return strtoul( sptr, eptr, base );
} // strto

long long int strto( const char * sptr, char ** eptr, int base ) {
	return strtoll( sptr, eptr, base );
} // strto

unsigned long long int strto( const char * sptr, char ** eptr, int base ) {
	return strtoull( sptr, eptr, base );
} // strto


float strto( const char * sptr, char ** eptr ) {
	return strtof( sptr, eptr );
} // strto

double strto( const char * sptr, char ** eptr ) {
	return strtod( sptr, eptr );
} // strto

long double strto( const char * sptr, char ** eptr ) {
	return strtold( sptr, eptr );
} // strto


float _Complex strto( const char * sptr, char ** eptr ) {
	float re, im;
	re = strtof( sptr, eptr );
	if ( sptr == *eptr ) return 0.0;
	im = strtof( sptr, eptr );
	if ( sptr == *eptr ) return 0.0;
	return re + im * _Complex_I;
} // strto

double _Complex strto( const char * sptr, char ** eptr ) {
	double re, im;
	re = strtod( sptr, eptr );
	if ( sptr == *eptr ) return 0.0;
	im = strtod( sptr, eptr );
	if ( sptr == *eptr ) return 0.0;
	return re + im * _Complex_I;
} // strto

long double _Complex strto( const char * sptr, char ** eptr ) {
	long double re, im;
	re = strtold( sptr, eptr );
	if ( sptr == *eptr ) return 0.0;
	im = strtold( sptr, eptr );
	if ( sptr == *eptr ) return 0.0;
	return re + im * _Complex_I;
} // strto

//---------------------------------------

forall( otype T | { int ?<?( T, T ); } )
T * bsearch( T key, const T * arr, size_t dim ) {
	int comp( const void * t1, const void * t2 ) { return *(T *)t1 < *(T *)t2 ? -1 : *(T *)t2 < *(T *)t1 ? 1 : 0; }
	return (T *)bsearch( &key, arr, dim, sizeof(T), comp );
} // bsearch

forall( otype T | { int ?<?( T, T ); } )
unsigned int bsearch( T key, const T * arr, size_t dim ) {
	T *result = bsearch( key, arr, dim );
	return result ? result - arr : dim;					// pointer subtraction includes sizeof(T)
} // bsearch

forall( otype T | { int ?<?( T, T ); } )
void qsort( const T * arr, size_t dim ) {
	int comp( const void * t1, const void * t2 ) { return *(T *)t1 < *(T *)t2 ? -1 : *(T *)t2 < *(T *)t1 ? 1 : 0; }
	qsort( arr, dim, sizeof(T), comp );
} // qsort

//---------------------------------------

[ int, int ] div( int num, int denom ) { div_t qr = div( num, denom ); return [ qr.quot, qr.rem ]; }
[ long int, long int ] div( long int num, long int denom ) { ldiv_t qr = ldiv( num, denom ); return [ qr.quot, qr.rem ]; }
[ long long int, long long int ] div( long long int num, long long int denom ) { lldiv_t qr = lldiv( num, denom ); return [ qr.quot, qr.rem ]; }
forall( otype T | { T ?/?( T, T ); T ?%?( T, T ); } )
[ T, T ] div( T num, T denom ) { return [ num / denom, num % denom ]; }

//---------------------------------------

unsigned char abs( signed char v ) { return abs( (int)v ); }
unsigned long int abs( long int v ) { return labs( v ); }
unsigned long long int abs( long long int v ) { return llabs( v ); }
float abs( float x ) { return fabsf( x ); }
double abs( double x ) { return fabs( x ); }
long double abs( long double x ) { return fabsl( x ); }
float abs( float _Complex x ) { return cabsf( x ); }
double abs( double _Complex x ) { return cabs( x ); }
long double abs( long double _Complex x ) { return cabsl( x ); }

//---------------------------------------

void rand48seed( long int s ) { srand48( s ); }
char rand48( void ) { return mrand48(); }
int rand48( void ) { return mrand48(); }
unsigned int rand48( void ) { return lrand48(); }
long int rand48( void ) { return mrand48(); }
unsigned long int rand48( void ) { return lrand48(); }
float rand48( void ) { return (float)drand48(); }		// otherwise float uses lrand48
double rand48( void ) { return drand48(); }
float _Complex rand48( void ) { return (float)drand48() + (float _Complex)(drand48() * _Complex_I); }
double _Complex rand48( void ) { return drand48() + (double _Complex)(drand48() * _Complex_I); }
long double _Complex rand48( void) { return (long double)drand48() + (long double _Complex)(drand48() * _Complex_I); }

//---------------------------------------

forall( otype T | { int ?<?( T, T ); } )
T min( T t1, T t2 ) {
	return t1 < t2 ? t1 : t2;
} // min

forall( otype T | { int ?>?( T, T ); } )
T max( T t1, T t2 ) {
	return t1 > t2 ? t1 : t2;
} // max

forall( otype T | { T min( T, T ); T max( T, T ); } )
T clamp( T value, T min_val, T max_val ) {
	return max( min_val, min( value, max_val ) );
} // clamp

forall( otype T )
void swap( T & t1, T & t2 ) {
	T temp = t1;
	t1 = t2;
	t2 = temp;
} // swap

// Local Variables: //
// tab-width: 4 //
// End: //
