//
// Cforall Version 1.0.0 Copyright (C) 2015 University of Waterloo
//
// The contents of this file are covered under the licence agreement in the
// file "LICENCE" distributed with Cforall.
//
// Mangler.h --
//
// Author           : Richard C. Bilson
// Created On       : Sun May 17 21:44:03 2015
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Jul 22 09:45:30 2017
// Update Count     : 15
//

#include "Mangler.h"
#include "SynTree/Type.h"

namespace SymTab {
	namespace Mangler {
		const char * btLetter[] = {
			"b",  // Bool
			"c",  // Char
			"Sc", // SignedChar
			"Uc", // UnsignedChar
			"s",  // ShortSignedInt
			"Us", // ShortUnsignedInt
			"i",  // SignedInt
			"Ui", // UnsignedInt
			"l",  // LongSignedInt
			"Ul", // LongUnsignedInt
			"q",  // LongLongSignedInt
			"Uq", // LongLongUnsignedInt
			"f",  // Float
			"d",  // Double
			"r",  // LongDouble
			"Xf", // FloatComplex
			"Xd", // DoubleComplex
			"Xr", // LongDoubleComplex
			"If", // FloatImaginary
			"Id", // DoubleImaginary
			"Ir", // LongDoubleImaginary
			"w",  // SignedInt128
			"Uw", // UnsignedInt128
			"x",  // Float80
			"y",  // Float128
		};
		const int numBtLetter = sizeof(btLetter)/sizeof(btLetter[0]);
		static_assert(
			numBtLetter == BasicType::NUMBER_OF_BASIC_TYPES,
			"Each basic type kind should have a corresponding mangler letter"
		);

		const std::map<int, const char *> qualifierLetter = {
			{ Type::Const, "C" },
			{ Type::Volatile, "V" },
			{ Type::Atomic, "A" }, // A = Atomic, A0 = Array and forall parameter...
			{ Type::Mutex, "M" },
			{ Type::Lvalue, "L" },
		};

		const std::string nameSeparator = "__cfa__";
	} // namespace Mangler
} // namespace SymTab
